@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.JitAuthorizationPoliciesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The JIT authorization policies.
 * @property principalId The the principal id that will be granted JIT access.
 * @property roleDefinitionId The role definition id that will be granted to the Principal.
 */
public data class JitAuthorizationPoliciesArgs(
    public val principalId: Output<String>,
    public val roleDefinitionId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.JitAuthorizationPoliciesArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.JitAuthorizationPoliciesArgs =
        com.pulumi.azurenative.solutions.inputs.JitAuthorizationPoliciesArgs.builder()
            .principalId(principalId.applyValue({ args0 -> args0 }))
            .roleDefinitionId(roleDefinitionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JitAuthorizationPoliciesArgs].
 */
@PulumiTagMarker
public class JitAuthorizationPoliciesArgsBuilder internal constructor() {
    private var principalId: Output<String>? = null

    private var roleDefinitionId: Output<String>? = null

    /**
     * @param value The the principal id that will be granted JIT access.
     */
    @JvmName("ffedlbmovrnejmni")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value The role definition id that will be granted to the Principal.
     */
    @JvmName("oouutplvfivaruro")
    public suspend fun roleDefinitionId(`value`: Output<String>) {
        this.roleDefinitionId = value
    }

    /**
     * @param value The the principal id that will be granted JIT access.
     */
    @JvmName("xtwdodddfishcqtj")
    public suspend fun principalId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    /**
     * @param value The role definition id that will be granted to the Principal.
     */
    @JvmName("oacvbbcpyfnropor")
    public suspend fun roleDefinitionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roleDefinitionId = mapped
    }

    internal fun build(): JitAuthorizationPoliciesArgs = JitAuthorizationPoliciesArgs(
        principalId = principalId ?: throw PulumiNullFieldException("principalId"),
        roleDefinitionId = roleDefinitionId ?: throw PulumiNullFieldException("roleDefinitionId"),
    )
}
