@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.inputs

import com.pulumi.azurenative.solutions.inputs.SkuArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU for the resource.
 * @property capacity The SKU capacity.
 * @property family The SKU family.
 * @property model The SKU model.
 * @property name The SKU name.
 * @property size The SKU size.
 * @property tier The SKU tier.
 */
public data class SkuArgs(
    public val capacity: Output<Int>? = null,
    public val family: Output<String>? = null,
    public val model: Output<String>? = null,
    public val name: Output<String>,
    public val size: Output<String>? = null,
    public val tier: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.solutions.inputs.SkuArgs> {
    override fun toJava(): com.pulumi.azurenative.solutions.inputs.SkuArgs =
        com.pulumi.azurenative.solutions.inputs.SkuArgs.builder()
            .capacity(capacity?.applyValue({ args0 -> args0 }))
            .family(family?.applyValue({ args0 -> args0 }))
            .model(model?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .size(size?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SkuArgs].
 */
@PulumiTagMarker
public class SkuArgsBuilder internal constructor() {
    private var capacity: Output<Int>? = null

    private var family: Output<String>? = null

    private var model: Output<String>? = null

    private var name: Output<String>? = null

    private var size: Output<String>? = null

    private var tier: Output<String>? = null

    /**
     * @param value The SKU capacity.
     */
    @JvmName("cqpijgmgwfvndwhb")
    public suspend fun capacity(`value`: Output<Int>) {
        this.capacity = value
    }

    /**
     * @param value The SKU family.
     */
    @JvmName("fdxsigrfqgiruefb")
    public suspend fun family(`value`: Output<String>) {
        this.family = value
    }

    /**
     * @param value The SKU model.
     */
    @JvmName("hgelavigbpfbntnr")
    public suspend fun model(`value`: Output<String>) {
        this.model = value
    }

    /**
     * @param value The SKU name.
     */
    @JvmName("mfeknqpsvunkuydc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The SKU size.
     */
    @JvmName("qhvfujyvqivcgtcn")
    public suspend fun size(`value`: Output<String>) {
        this.size = value
    }

    /**
     * @param value The SKU tier.
     */
    @JvmName("nsvsxcrnrufwwuvs")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value The SKU capacity.
     */
    @JvmName("rlimbeepaufmyfrg")
    public suspend fun capacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacity = mapped
    }

    /**
     * @param value The SKU family.
     */
    @JvmName("defjxgjmowadaxcn")
    public suspend fun family(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.family = mapped
    }

    /**
     * @param value The SKU model.
     */
    @JvmName("upltftdkfgdoieit")
    public suspend fun model(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.model = mapped
    }

    /**
     * @param value The SKU name.
     */
    @JvmName("bmhsrnmesxbnsspl")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The SKU size.
     */
    @JvmName("giblduxeyutdwyey")
    public suspend fun size(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.size = mapped
    }

    /**
     * @param value The SKU tier.
     */
    @JvmName("pmtngytaxuwlbvkb")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): SkuArgs = SkuArgs(
        capacity = capacity,
        family = family,
        model = model,
        name = name ?: throw PulumiNullFieldException("name"),
        size = size,
        tier = tier,
    )
}
