@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Managed application billing details definition.
 * @property resourceUsageId The managed application resource usage Id.
 */
public data class ApplicationBillingDetailsDefinitionResponse(
    public val resourceUsageId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationBillingDetailsDefinitionResponse):
            ApplicationBillingDetailsDefinitionResponse = ApplicationBillingDetailsDefinitionResponse(
            resourceUsageId = javaType.resourceUsageId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
