@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The application package contact information.
 * @property contactName The contact name.
 * @property email The contact email.
 * @property phone The contact phone number.
 */
public data class ApplicationPackageContactResponse(
    public val contactName: String? = null,
    public val email: String,
    public val phone: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.ApplicationPackageContactResponse):
            ApplicationPackageContactResponse = ApplicationPackageContactResponse(
            contactName = javaType.contactName().map({ args0 -> args0 }).orElse(null),
            email = javaType.email(),
            phone = javaType.phone(),
        )
    }
}
