@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Information about managed application definition.
 * @property artifacts The collection of managed application artifacts. The portal will use the files specified as artifacts to construct the user experience of creating a managed application from a managed application definition.
 * @property authorizations The managed application provider authorizations.
 * @property createUiDefinition The createUiDefinition json for the backing template with Microsoft.Solutions/applications resource. It can be a JObject or well-formed JSON string.
 * @property deploymentPolicy The managed application deployment policy.
 * @property description The managed application definition description.
 * @property displayName The managed application definition display name.
 * @property id Resource ID
 * @property isEnabled A value indicating whether the package is enabled or not.
 * @property location Resource location
 * @property lockLevel The managed application lock level.
 * @property lockingPolicy The managed application locking policy.
 * @property mainTemplate The inline main template json which has resources to be provisioned. It can be a JObject or well-formed JSON string.
 * @property managedBy ID of the resource that manages this resource.
 * @property managementPolicy The managed application management policy that determines publisher's access to the managed resource group.
 * @property name Resource name
 * @property notificationPolicy The managed application notification policy.
 * @property packageFileUri The managed application definition package file Uri. Use this element
 * @property policies The managed application provider policies.
 * @property sku The SKU of the resource.
 * @property storageAccountId The storage account id for bring your own storage scenario.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags
 * @property type Resource type
 */
public data class GetApplicationDefinitionResult(
    public val artifacts: List<ApplicationDefinitionArtifactResponse>? = null,
    public val authorizations: List<ApplicationAuthorizationResponse>? = null,
    public val createUiDefinition: Any? = null,
    public val deploymentPolicy: ApplicationDeploymentPolicyResponse? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val id: String,
    public val isEnabled: Boolean? = null,
    public val location: String? = null,
    public val lockLevel: String,
    public val lockingPolicy: ApplicationPackageLockingPolicyDefinitionResponse? = null,
    public val mainTemplate: Any? = null,
    public val managedBy: String? = null,
    public val managementPolicy: ApplicationManagementPolicyResponse? = null,
    public val name: String,
    public val notificationPolicy: ApplicationNotificationPolicyResponse? = null,
    public val packageFileUri: String? = null,
    public val policies: List<ApplicationPolicyResponse>? = null,
    public val sku: SkuResponse? = null,
    public val storageAccountId: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.GetApplicationDefinitionResult):
            GetApplicationDefinitionResult = GetApplicationDefinitionResult(
            artifacts = javaType.artifacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationDefinitionArtifactResponse.Companion.toKotlin(args0)
                })
            }),
            authorizations = javaType.authorizations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationAuthorizationResponse.Companion.toKotlin(args0)
                })
            }),
            createUiDefinition = javaType.createUiDefinition().map({ args0 -> args0 }).orElse(null),
            deploymentPolicy = javaType.deploymentPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationDeploymentPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isEnabled = javaType.isEnabled().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            lockLevel = javaType.lockLevel(),
            lockingPolicy = javaType.lockingPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPackageLockingPolicyDefinitionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            mainTemplate = javaType.mainTemplate().map({ args0 -> args0 }).orElse(null),
            managedBy = javaType.managedBy().map({ args0 -> args0 }).orElse(null),
            managementPolicy = javaType.managementPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationManagementPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            notificationPolicy = javaType.notificationPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationNotificationPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            packageFileUri = javaType.packageFileUri().map({ args0 -> args0 }).orElse(null),
            policies = javaType.policies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.solutions.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
