@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.solutions.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Information about JIT request definition.
 * @property applicationResourceId The parent application id.
 * @property createdBy The client entity that created the JIT request.
 * @property id Resource ID
 * @property jitAuthorizationPolicies The JIT authorization policies.
 * @property jitRequestState The JIT request state.
 * @property jitSchedulingPolicy The JIT request properties.
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState The JIT request provisioning state.
 * @property publisherTenantId The publisher tenant id.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags Resource tags
 * @property type Resource type
 * @property updatedBy The client entity that last updated the JIT request.
 */
public data class GetJitRequestResult(
    public val applicationResourceId: String,
    public val createdBy: ApplicationClientDetailsResponse,
    public val id: String,
    public val jitAuthorizationPolicies: List<JitAuthorizationPoliciesResponse>,
    public val jitRequestState: String,
    public val jitSchedulingPolicy: JitSchedulingPolicyResponse,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val publisherTenantId: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val updatedBy: ApplicationClientDetailsResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.solutions.outputs.GetJitRequestResult):
            GetJitRequestResult = GetJitRequestResult(
            applicationResourceId = javaType.applicationResourceId(),
            createdBy = javaType.createdBy().let({ args0 ->
                com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationClientDetailsResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            jitAuthorizationPolicies = javaType.jitAuthorizationPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.solutions.kotlin.outputs.JitAuthorizationPoliciesResponse.Companion.toKotlin(args0)
                })
            }),
            jitRequestState = javaType.jitRequestState(),
            jitSchedulingPolicy = javaType.jitSchedulingPolicy().let({ args0 ->
                com.pulumi.azurenative.solutions.kotlin.outputs.JitSchedulingPolicyResponse.Companion.toKotlin(args0)
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            publisherTenantId = javaType.publisherTenantId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.solutions.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            updatedBy = javaType.updatedBy().let({ args0 ->
                com.pulumi.azurenative.solutions.kotlin.outputs.ApplicationClientDetailsResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
