@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BackupShortTermRetentionPolicy].
 */
@PulumiTagMarker
public class BackupShortTermRetentionPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupShortTermRetentionPolicyArgs = BackupShortTermRetentionPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupShortTermRetentionPolicyArgsBuilder.() -> Unit) {
        val builder = BackupShortTermRetentionPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): BackupShortTermRetentionPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.sql.BackupShortTermRetentionPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return BackupShortTermRetentionPolicy(builtJavaResource)
    }
}

/**
 * A short term retention policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Update the short term retention policy for the database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupShortTermRetentionPolicy = new AzureNative.Sql.BackupShortTermRetentionPolicy("backupShortTermRetentionPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         DiffBackupIntervalInHours = 24,
 *         PolicyName = "default",
 *         ResourceGroupName = "resourceGroup",
 *         RetentionDays = 7,
 *         ServerName = "testsvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewBackupShortTermRetentionPolicy(ctx, "backupShortTermRetentionPolicy", &sql.BackupShortTermRetentionPolicyArgs{
 * 			DatabaseName:              pulumi.String("testdb"),
 * 			DiffBackupIntervalInHours: pulumi.Int(24),
 * 			PolicyName:                pulumi.String("default"),
 * 			ResourceGroupName:         pulumi.String("resourceGroup"),
 * 			RetentionDays:             pulumi.Int(7),
 * 			ServerName:                pulumi.String("testsvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.BackupShortTermRetentionPolicy;
 * import com.pulumi.azurenative.sql.BackupShortTermRetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupShortTermRetentionPolicy = new BackupShortTermRetentionPolicy("backupShortTermRetentionPolicy", BackupShortTermRetentionPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .diffBackupIntervalInHours(24)
 *             .policyName("default")
 *             .resourceGroupName("resourceGroup")
 *             .retentionDays(7)
 *             .serverName("testsvr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:BackupShortTermRetentionPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}
 * ```
 */
public class BackupShortTermRetentionPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.BackupShortTermRetentionPolicy,
) : KotlinCustomResource(javaResource, BackupShortTermRetentionPolicyMapper) {
    /**
     * The differential backup interval in hours. This is how many interval hours between each differential backup will be supported. This is only applicable to live databases but not dropped databases.
     */
    public val diffBackupIntervalInHours: Output<Int>?
        get() = javaResource.diffBackupIntervalInHours().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     */
    public val retentionDays: Output<Int>?
        get() = javaResource.retentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object BackupShortTermRetentionPolicyMapper : ResourceMapper<BackupShortTermRetentionPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.BackupShortTermRetentionPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupShortTermRetentionPolicy =
        BackupShortTermRetentionPolicy(
            javaResource as
                com.pulumi.azurenative.sql.BackupShortTermRetentionPolicy,
        )
}

/**
 * @see [BackupShortTermRetentionPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupShortTermRetentionPolicy].
 */
public suspend fun backupShortTermRetentionPolicy(
    name: String,
    block: suspend BackupShortTermRetentionPolicyResourceBuilder.() -> Unit,
):
    BackupShortTermRetentionPolicy {
    val builder = BackupShortTermRetentionPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupShortTermRetentionPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupShortTermRetentionPolicy(name: String): BackupShortTermRetentionPolicy {
    val builder = BackupShortTermRetentionPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
