@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.BackupShortTermRetentionPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A short term retention policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Update the short term retention policy for the database.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var backupShortTermRetentionPolicy = new AzureNative.Sql.BackupShortTermRetentionPolicy("backupShortTermRetentionPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         DiffBackupIntervalInHours = 24,
 *         PolicyName = "default",
 *         ResourceGroupName = "resourceGroup",
 *         RetentionDays = 7,
 *         ServerName = "testsvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewBackupShortTermRetentionPolicy(ctx, "backupShortTermRetentionPolicy", &sql.BackupShortTermRetentionPolicyArgs{
 * 			DatabaseName:              pulumi.String("testdb"),
 * 			DiffBackupIntervalInHours: pulumi.Int(24),
 * 			PolicyName:                pulumi.String("default"),
 * 			ResourceGroupName:         pulumi.String("resourceGroup"),
 * 			RetentionDays:             pulumi.Int(7),
 * 			ServerName:                pulumi.String("testsvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.BackupShortTermRetentionPolicy;
 * import com.pulumi.azurenative.sql.BackupShortTermRetentionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var backupShortTermRetentionPolicy = new BackupShortTermRetentionPolicy("backupShortTermRetentionPolicy", BackupShortTermRetentionPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .diffBackupIntervalInHours(24)
 *             .policyName("default")
 *             .resourceGroupName("resourceGroup")
 *             .retentionDays(7)
 *             .serverName("testsvr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:BackupShortTermRetentionPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/backupShortTermRetentionPolicies/{policyName}
 * ```
 * @property databaseName The name of the database.
 * @property diffBackupIntervalInHours The differential backup interval in hours. This is how many interval hours between each differential backup will be supported. This is only applicable to live databases but not dropped databases.
 * @property policyName The policy name. Should always be "default".
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property retentionDays The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
 * @property serverName The name of the server.
 */
public data class BackupShortTermRetentionPolicyArgs(
    public val databaseName: Output<String>? = null,
    public val diffBackupIntervalInHours: Output<Int>? = null,
    public val policyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val retentionDays: Output<Int>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.BackupShortTermRetentionPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.BackupShortTermRetentionPolicyArgs =
        com.pulumi.azurenative.sql.BackupShortTermRetentionPolicyArgs.builder()
            .databaseName(databaseName?.applyValue({ args0 -> args0 }))
            .diffBackupIntervalInHours(diffBackupIntervalInHours?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .retentionDays(retentionDays?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [BackupShortTermRetentionPolicyArgs].
 */
@PulumiTagMarker
public class BackupShortTermRetentionPolicyArgsBuilder internal constructor() {
    private var databaseName: Output<String>? = null

    private var diffBackupIntervalInHours: Output<Int>? = null

    private var policyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var retentionDays: Output<Int>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("rxoiusakkpmvpftk")
    public suspend fun databaseName(`value`: Output<String>) {
        this.databaseName = value
    }

    /**
     * @param value The differential backup interval in hours. This is how many interval hours between each differential backup will be supported. This is only applicable to live databases but not dropped databases.
     */
    @JvmName("tytcoiemaysrwxsa")
    public suspend fun diffBackupIntervalInHours(`value`: Output<Int>) {
        this.diffBackupIntervalInHours = value
    }

    /**
     * @param value The policy name. Should always be "default".
     */
    @JvmName("vanjwdwixgrxyadk")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("aittenytbnhkgbix")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     */
    @JvmName("luasfsaiynrillqe")
    public suspend fun retentionDays(`value`: Output<Int>) {
        this.retentionDays = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("tkdgowstobfvifni")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the database.
     */
    @JvmName("osvsycnyesxgtgtq")
    public suspend fun databaseName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.databaseName = mapped
    }

    /**
     * @param value The differential backup interval in hours. This is how many interval hours between each differential backup will be supported. This is only applicable to live databases but not dropped databases.
     */
    @JvmName("cjachjaqictoenof")
    public suspend fun diffBackupIntervalInHours(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diffBackupIntervalInHours = mapped
    }

    /**
     * @param value The policy name. Should always be "default".
     */
    @JvmName("lohhtujolxjlvecx")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ndamvqsibeeljslv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The backup retention period in days. This is how many days Point-in-Time Restore will be supported.
     */
    @JvmName("thncwhpbdnaptbsx")
    public suspend fun retentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionDays = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("exqimnsxeavhwggx")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): BackupShortTermRetentionPolicyArgs = BackupShortTermRetentionPolicyArgs(
        databaseName = databaseName,
        diffBackupIntervalInHours = diffBackupIntervalInHours,
        policyName = policyName,
        resourceGroupName = resourceGroupName,
        retentionDays = retentionDays,
        serverName = serverName,
    )
}
