@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.RecommendedActionResponse
import com.pulumi.azurenative.sql.kotlin.outputs.RecommendedActionResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DatabaseAdvisor].
 */
@PulumiTagMarker
public class DatabaseAdvisorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseAdvisorArgs = DatabaseAdvisorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseAdvisorArgsBuilder.() -> Unit) {
        val builder = DatabaseAdvisorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DatabaseAdvisor {
        val builtJavaResource = com.pulumi.azurenative.sql.DatabaseAdvisor(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DatabaseAdvisor(builtJavaResource)
    }
}

/**
 * Database, Server or Elastic Pool Advisor.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Update database advisor
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseAdvisor = new AzureNative.Sql.DatabaseAdvisor("databaseAdvisor", new()
 *     {
 *         AdvisorName = "CreateIndex",
 *         AutoExecuteStatus = AzureNative.Sql.AutoExecuteStatus.Disabled,
 *         DatabaseName = "IndexAdvisor_test_3",
 *         ResourceGroupName = "workloadinsight-demos",
 *         ServerName = "misosisvr",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseAdvisor(ctx, "databaseAdvisor", &sql.DatabaseAdvisorArgs{
 * 			AdvisorName:       pulumi.String("CreateIndex"),
 * 			AutoExecuteStatus: sql.AutoExecuteStatusDisabled,
 * 			DatabaseName:      pulumi.String("IndexAdvisor_test_3"),
 * 			ResourceGroupName: pulumi.String("workloadinsight-demos"),
 * 			ServerName:        pulumi.String("misosisvr"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseAdvisor;
 * import com.pulumi.azurenative.sql.DatabaseAdvisorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseAdvisor = new DatabaseAdvisor("databaseAdvisor", DatabaseAdvisorArgs.builder()
 *             .advisorName("CreateIndex")
 *             .autoExecuteStatus("Disabled")
 *             .databaseName("IndexAdvisor_test_3")
 *             .resourceGroupName("workloadinsight-demos")
 *             .serverName("misosisvr")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DatabaseAdvisor CreateIndex /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/advisors/{advisorName}
 * ```
 */
public class DatabaseAdvisor internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.DatabaseAdvisor,
) : KotlinCustomResource(javaResource, DatabaseAdvisorMapper) {
    /**
     * Gets the status of availability of this advisor to customers. Possible values are 'GA', 'PublicPreview', 'LimitedPublicPreview' and 'PrivatePreview'.
     */
    public val advisorStatus: Output<String>
        get() = javaResource.advisorStatus().applyValue({ args0 -> args0 })

    /**
     * Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
     */
    public val autoExecuteStatus: Output<String>
        get() = javaResource.autoExecuteStatus().applyValue({ args0 -> args0 })

    /**
     * Gets the resource from which current value of auto-execute status is inherited. Auto-execute status can be set on (and inherited from) different levels in the resource hierarchy. Possible values are 'Subscription', 'Server', 'ElasticPool', 'Database' and 'Default' (when status is not explicitly set on any level).
     */
    public val autoExecuteStatusInheritedFrom: Output<String>
        get() = javaResource.autoExecuteStatusInheritedFrom().applyValue({ args0 -> args0 })

    /**
     * Resource kind.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * Gets the time when the current resource was analyzed for recommendations by this advisor.
     */
    public val lastChecked: Output<String>
        get() = javaResource.lastChecked().applyValue({ args0 -> args0 })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Gets that status of recommendations for this advisor and reason for not having any recommendations. Possible values include, but are not limited to, 'Ok' (Recommendations available),LowActivity (not enough workload to analyze), 'DbSeemsTuned' (Database is doing well), etc.
     */
    public val recommendationsStatus: Output<String>
        get() = javaResource.recommendationsStatus().applyValue({ args0 -> args0 })

    /**
     * Gets the recommended actions for this advisor.
     */
    public val recommendedActions: Output<List<RecommendedActionResponse>>
        get() = javaResource.recommendedActions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatabaseAdvisorMapper : ResourceMapper<DatabaseAdvisor> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.DatabaseAdvisor::class == javaResource::class

    override fun map(javaResource: Resource): DatabaseAdvisor = DatabaseAdvisor(
        javaResource as
            com.pulumi.azurenative.sql.DatabaseAdvisor,
    )
}

/**
 * @see [DatabaseAdvisor].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DatabaseAdvisor].
 */
public suspend fun databaseAdvisor(
    name: String,
    block: suspend DatabaseAdvisorResourceBuilder.() -> Unit,
): DatabaseAdvisor {
    val builder = DatabaseAdvisorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DatabaseAdvisor].
 * @param name The _unique_ name of the resulting resource.
 */
public fun databaseAdvisor(name: String): DatabaseAdvisor {
    val builder = DatabaseAdvisorResourceBuilder()
    builder.name(name)
    return builder.build()
}
