@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DatabaseSecurityAlertPolicy].
 */
@PulumiTagMarker
public class DatabaseSecurityAlertPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseSecurityAlertPolicyArgs = DatabaseSecurityAlertPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseSecurityAlertPolicyArgsBuilder.() -> Unit) {
        val builder = DatabaseSecurityAlertPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DatabaseSecurityAlertPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DatabaseSecurityAlertPolicy(builtJavaResource)
    }
}

/**
 * A database security alert policy.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2018-06-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Update a database's threat detection policy with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseSecurityAlertPolicy = new AzureNative.Sql.DatabaseSecurityAlertPolicy("databaseSecurityAlertPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         DisabledAlerts = new[]
 *         {
 *             "Sql_Injection",
 *             "Usage_Anomaly",
 *         },
 *         EmailAccountAdmins = true,
 *         EmailAddresses = new[]
 *         {
 *             "test@microsoft.com",
 *             "user@microsoft.com",
 *         },
 *         ResourceGroupName = "securityalert-4799",
 *         RetentionDays = 6,
 *         SecurityAlertPolicyName = "default",
 *         ServerName = "securityalert-6440",
 *         State = AzureNative.Sql.SecurityAlertsPolicyState.Enabled,
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseSecurityAlertPolicy(ctx, "databaseSecurityAlertPolicy", &sql.DatabaseSecurityAlertPolicyArgs{
 * 			DatabaseName: pulumi.String("testdb"),
 * 			DisabledAlerts: pulumi.StringArray{
 * 				pulumi.String("Sql_Injection"),
 * 				pulumi.String("Usage_Anomaly"),
 * 			},
 * 			EmailAccountAdmins: pulumi.Bool(true),
 * 			EmailAddresses: pulumi.StringArray{
 * 				pulumi.String("test@microsoft.com"),
 * 				pulumi.String("user@microsoft.com"),
 * 			},
 * 			ResourceGroupName:       pulumi.String("securityalert-4799"),
 * 			RetentionDays:           pulumi.Int(6),
 * 			SecurityAlertPolicyName: pulumi.String("default"),
 * 			ServerName:              pulumi.String("securityalert-6440"),
 * 			State:                   sql.SecurityAlertsPolicyStateEnabled,
 * 			StorageAccountAccessKey: pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageEndpoint:         pulumi.String("https://mystorage.blob.core.windows.net"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicy;
 * import com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseSecurityAlertPolicy = new DatabaseSecurityAlertPolicy("databaseSecurityAlertPolicy", DatabaseSecurityAlertPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .disabledAlerts(
 *                 "Sql_Injection",
 *                 "Usage_Anomaly")
 *             .emailAccountAdmins(true)
 *             .emailAddresses(
 *                 "test@microsoft.com",
 *                 "user@microsoft.com")
 *             .resourceGroupName("securityalert-4799")
 *             .retentionDays(6)
 *             .securityAlertPolicyName("default")
 *             .serverName("securityalert-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a database's threat detection policy with minimal parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseSecurityAlertPolicy = new AzureNative.Sql.DatabaseSecurityAlertPolicy("databaseSecurityAlertPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         ResourceGroupName = "securityalert-4799",
 *         SecurityAlertPolicyName = "default",
 *         ServerName = "securityalert-6440",
 *         State = AzureNative.Sql.SecurityAlertsPolicyState.Enabled,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseSecurityAlertPolicy(ctx, "databaseSecurityAlertPolicy", &sql.DatabaseSecurityAlertPolicyArgs{
 * 			DatabaseName:            pulumi.String("testdb"),
 * 			ResourceGroupName:       pulumi.String("securityalert-4799"),
 * 			SecurityAlertPolicyName: pulumi.String("default"),
 * 			ServerName:              pulumi.String("securityalert-6440"),
 * 			State:                   sql.SecurityAlertsPolicyStateEnabled,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicy;
 * import com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseSecurityAlertPolicy = new DatabaseSecurityAlertPolicy("databaseSecurityAlertPolicy", DatabaseSecurityAlertPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .resourceGroupName("securityalert-4799")
 *             .securityAlertPolicyName("default")
 *             .serverName("securityalert-6440")
 *             .state("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DatabaseSecurityAlertPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}
 * ```
 */
public class DatabaseSecurityAlertPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicy,
) : KotlinCustomResource(javaResource, DatabaseSecurityAlertPolicyMapper) {
    /**
     * Specifies the UTC creation time of the policy.
     */
    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * Specifies an array of alerts that are disabled. Allowed values are: Sql_Injection, Sql_Injection_Vulnerability, Access_Anomaly, Data_Exfiltration, Unsafe_Action, Brute_Force
     */
    public val disabledAlerts: Output<List<String>>?
        get() = javaResource.disabledAlerts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Specifies that the alert is sent to the account administrators.
     */
    public val emailAccountAdmins: Output<Boolean>?
        get() = javaResource.emailAccountAdmins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies an array of e-mail addresses to which the alert is sent.
     */
    public val emailAddresses: Output<List<String>>?
        get() = javaResource.emailAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the number of days to keep in the Threat Detection audit logs.
     */
    public val retentionDays: Output<Int>?
        get() = javaResource.retentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the state of the policy, whether it is enabled or disabled or a policy has not been applied yet on the specific database.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Specifies the identifier key of the Threat Detection audit storage account.
     */
    public val storageAccountAccessKey: Output<String>?
        get() = javaResource.storageAccountAccessKey().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs.
     */
    public val storageEndpoint: Output<String>?
        get() = javaResource.storageEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SystemData of SecurityAlertPolicyResource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatabaseSecurityAlertPolicyMapper : ResourceMapper<DatabaseSecurityAlertPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicy::class == javaResource::class

    override fun map(javaResource: Resource): DatabaseSecurityAlertPolicy =
        DatabaseSecurityAlertPolicy(
            javaResource as
                com.pulumi.azurenative.sql.DatabaseSecurityAlertPolicy,
        )
}

/**
 * @see [DatabaseSecurityAlertPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DatabaseSecurityAlertPolicy].
 */
public suspend fun databaseSecurityAlertPolicy(
    name: String,
    block: suspend DatabaseSecurityAlertPolicyResourceBuilder.() -> Unit,
):
    DatabaseSecurityAlertPolicy {
    val builder = DatabaseSecurityAlertPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DatabaseSecurityAlertPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun databaseSecurityAlertPolicy(name: String): DatabaseSecurityAlertPolicy {
    val builder = DatabaseSecurityAlertPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
