@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.sql.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DatabaseSqlVulnerabilityAssessmentRuleBaseline].
 */
@PulumiTagMarker
public class DatabaseSqlVulnerabilityAssessmentRuleBaselineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs =
        DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend DatabaseSqlVulnerabilityAssessmentRuleBaselineArgsBuilder.() -> Unit) {
        val builder = DatabaseSqlVulnerabilityAssessmentRuleBaselineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DatabaseSqlVulnerabilityAssessmentRuleBaseline {
        val builtJavaResource =
            com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaseline(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DatabaseSqlVulnerabilityAssessmentRuleBaseline(builtJavaResource)
    }
}

/**
 * A database sql vulnerability assessment rule baseline.
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Creates or updates a database's vulnerability assessment rule baseline.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseSqlVulnerabilityAssessmentRuleBaseline = new AzureNative.Sql.DatabaseSqlVulnerabilityAssessmentRuleBaseline("databaseSqlVulnerabilityAssessmentRuleBaseline", new()
 *     {
 *         BaselineName = "default",
 *         DatabaseName = "testdb",
 *         LatestScan = false,
 *         ResourceGroupName = "vulnerabilityaseessmenttest-4799",
 *         Results = new[]
 *         {
 *             new[]
 *             {
 *                 "userA",
 *                 "SELECT",
 *             },
 *             new[]
 *             {
 *                 "userB",
 *                 "SELECT",
 *             },
 *             new[]
 *             {
 *                 "userC",
 *                 "SELECT",
 *             },
 *         },
 *         RuleId = "VA1001",
 *         ServerName = "vulnerabilityaseessmenttest-6440",
 *         VulnerabilityAssessmentName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseSqlVulnerabilityAssessmentRuleBaseline(ctx, "databaseSqlVulnerabilityAssessmentRuleBaseline", &sql.DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs{
 * 			BaselineName:      pulumi.String("default"),
 * 			DatabaseName:      pulumi.String("testdb"),
 * 			LatestScan:        pulumi.Bool(false),
 * 			ResourceGroupName: pulumi.String("vulnerabilityaseessmenttest-4799"),
 * 			Results: pulumi.StringArrayArray{
 * 				pulumi.StringArray{
 * 					pulumi.String("userA"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("userB"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 				pulumi.StringArray{
 * 					pulumi.String("userC"),
 * 					pulumi.String("SELECT"),
 * 				},
 * 			},
 * 			RuleId:                      pulumi.String("VA1001"),
 * 			ServerName:                  pulumi.String("vulnerabilityaseessmenttest-6440"),
 * 			VulnerabilityAssessmentName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaseline;
 * import com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseSqlVulnerabilityAssessmentRuleBaseline = new DatabaseSqlVulnerabilityAssessmentRuleBaseline("databaseSqlVulnerabilityAssessmentRuleBaseline", DatabaseSqlVulnerabilityAssessmentRuleBaselineArgs.builder()
 *             .baselineName("default")
 *             .databaseName("testdb")
 *             .latestScan(false)
 *             .resourceGroupName("vulnerabilityaseessmenttest-4799")
 *             .results(
 *                     "userA",
 *                     "SELECT",
 *                     "userB",
 *                     "SELECT",
 *                     "userC",
 *                     "SELECT")
 *             .ruleId("VA1001")
 *             .serverName("vulnerabilityaseessmenttest-6440")
 *             .vulnerabilityAssessmentName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DatabaseSqlVulnerabilityAssessmentRuleBaseline Scan123 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}
 * ```
 */
public class DatabaseSqlVulnerabilityAssessmentRuleBaseline internal constructor(
    override val javaResource:
    com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaseline,
) : KotlinCustomResource(javaResource, DatabaseSqlVulnerabilityAssessmentRuleBaselineMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The rule baseline result
     */
    public val results: Output<List<List<String>>>
        get() = javaResource.results().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            })
        })

    /**
     * SystemData of DatabaseSqlVulnerabilityAssessmentRuleBaselineResource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatabaseSqlVulnerabilityAssessmentRuleBaselineMapper :
    ResourceMapper<DatabaseSqlVulnerabilityAssessmentRuleBaseline> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaseline::class == javaResource::class

    override fun map(javaResource: Resource): DatabaseSqlVulnerabilityAssessmentRuleBaseline =
        DatabaseSqlVulnerabilityAssessmentRuleBaseline(
            javaResource as
                com.pulumi.azurenative.sql.DatabaseSqlVulnerabilityAssessmentRuleBaseline,
        )
}

/**
 * @see [DatabaseSqlVulnerabilityAssessmentRuleBaseline].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DatabaseSqlVulnerabilityAssessmentRuleBaseline].
 */
public suspend fun databaseSqlVulnerabilityAssessmentRuleBaseline(
    name: String,
    block: suspend DatabaseSqlVulnerabilityAssessmentRuleBaselineResourceBuilder.() -> Unit,
):
    DatabaseSqlVulnerabilityAssessmentRuleBaseline {
    val builder = DatabaseSqlVulnerabilityAssessmentRuleBaselineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DatabaseSqlVulnerabilityAssessmentRuleBaseline].
 * @param name The _unique_ name of the resulting resource.
 */
public fun databaseSqlVulnerabilityAssessmentRuleBaseline(name: String):
    DatabaseSqlVulnerabilityAssessmentRuleBaseline {
    val builder = DatabaseSqlVulnerabilityAssessmentRuleBaselineResourceBuilder()
    builder.name(name)
    return builder.build()
}
