@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DatabaseThreatDetectionPolicy].
 */
@PulumiTagMarker
public class DatabaseThreatDetectionPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatabaseThreatDetectionPolicyArgs = DatabaseThreatDetectionPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatabaseThreatDetectionPolicyArgsBuilder.() -> Unit) {
        val builder = DatabaseThreatDetectionPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): DatabaseThreatDetectionPolicy {
        val builtJavaResource =
            com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicy(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DatabaseThreatDetectionPolicy(builtJavaResource)
    }
}

/**
 * Contains information about a database Threat Detection policy.
 * Azure REST API version: 2014-04-01.
 * ## Example Usage
 * ### Create database security alert policy max
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseThreatDetectionPolicy = new AzureNative.Sql.DatabaseThreatDetectionPolicy("databaseThreatDetectionPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         DisabledAlerts = "Sql_Injection;Usage_Anomaly;",
 *         EmailAccountAdmins = "Enabled",
 *         EmailAddresses = "test@microsoft.com;user@microsoft.com",
 *         ResourceGroupName = "securityalert-4799",
 *         RetentionDays = 6,
 *         SecurityAlertPolicyName = "default",
 *         ServerName = "securityalert-6440",
 *         State = "Enabled",
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *         UseServerDefault = "Enabled",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseThreatDetectionPolicy(ctx, "databaseThreatDetectionPolicy", &sql.DatabaseThreatDetectionPolicyArgs{
 * 			DatabaseName:            pulumi.String("testdb"),
 * 			DisabledAlerts:          pulumi.String("Sql_Injection;Usage_Anomaly;"),
 * 			EmailAccountAdmins:      pulumi.String("Enabled"),
 * 			EmailAddresses:          pulumi.String("test@microsoft.com;user@microsoft.com"),
 * 			ResourceGroupName:       pulumi.String("securityalert-4799"),
 * 			RetentionDays:           pulumi.Int(6),
 * 			SecurityAlertPolicyName: pulumi.String("default"),
 * 			ServerName:              pulumi.String("securityalert-6440"),
 * 			State:                   pulumi.String("Enabled"),
 * 			StorageAccountAccessKey: pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageEndpoint:         pulumi.String("https://mystorage.blob.core.windows.net"),
 * 			UseServerDefault:        pulumi.String("Enabled"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicy;
 * import com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseThreatDetectionPolicy = new DatabaseThreatDetectionPolicy("databaseThreatDetectionPolicy", DatabaseThreatDetectionPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .disabledAlerts("Sql_Injection;Usage_Anomaly;")
 *             .emailAccountAdmins("Enabled")
 *             .emailAddresses("test@microsoft.com;user@microsoft.com")
 *             .resourceGroupName("securityalert-4799")
 *             .retentionDays(6)
 *             .securityAlertPolicyName("default")
 *             .serverName("securityalert-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .useServerDefault("Enabled")
 *             .build());
 *     }
 * }
 * ```
 * ### Create database security alert policy min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var databaseThreatDetectionPolicy = new AzureNative.Sql.DatabaseThreatDetectionPolicy("databaseThreatDetectionPolicy", new()
 *     {
 *         DatabaseName = "testdb",
 *         ResourceGroupName = "securityalert-4799",
 *         SecurityAlertPolicyName = "default",
 *         ServerName = "securityalert-6440",
 *         State = "Enabled",
 *         StorageAccountAccessKey = "sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==",
 *         StorageEndpoint = "https://mystorage.blob.core.windows.net",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewDatabaseThreatDetectionPolicy(ctx, "databaseThreatDetectionPolicy", &sql.DatabaseThreatDetectionPolicyArgs{
 * 			DatabaseName:            pulumi.String("testdb"),
 * 			ResourceGroupName:       pulumi.String("securityalert-4799"),
 * 			SecurityAlertPolicyName: pulumi.String("default"),
 * 			ServerName:              pulumi.String("securityalert-6440"),
 * 			State:                   pulumi.String("Enabled"),
 * 			StorageAccountAccessKey: pulumi.String("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD=="),
 * 			StorageEndpoint:         pulumi.String("https://mystorage.blob.core.windows.net"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicy;
 * import com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var databaseThreatDetectionPolicy = new DatabaseThreatDetectionPolicy("databaseThreatDetectionPolicy", DatabaseThreatDetectionPolicyArgs.builder()
 *             .databaseName("testdb")
 *             .resourceGroupName("securityalert-4799")
 *             .securityAlertPolicyName("default")
 *             .serverName("securityalert-6440")
 *             .state("Enabled")
 *             .storageAccountAccessKey("sdlfkjabc+sdlfkjsdlkfsjdfLDKFTERLKFDFKLjsdfksjdflsdkfD2342309432849328476458/3RSD==")
 *             .storageEndpoint("https://mystorage.blob.core.windows.net")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:DatabaseThreatDetectionPolicy default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/securityAlertPolicies/{securityAlertPolicyName}
 * ```
 */
public class DatabaseThreatDetectionPolicy internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicy,
) : KotlinCustomResource(javaResource, DatabaseThreatDetectionPolicyMapper) {
    /**
     * Specifies the semicolon-separated list of alerts that are disabled, or empty string to disable no alerts. Possible values: Sql_Injection; Sql_Injection_Vulnerability; Access_Anomaly; Data_Exfiltration; Unsafe_Action.
     */
    public val disabledAlerts: Output<String>?
        get() = javaResource.disabledAlerts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies that the alert is sent to the account administrators.
     */
    public val emailAccountAdmins: Output<String>?
        get() = javaResource.emailAccountAdmins().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the semicolon-separated list of e-mail addresses to which the alert is sent.
     */
    public val emailAddresses: Output<String>?
        get() = javaResource.emailAddresses().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource kind.
     */
    public val kind: Output<String>
        get() = javaResource.kind().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the number of days to keep in the Threat Detection audit logs.
     */
    public val retentionDays: Output<Int>?
        get() = javaResource.retentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the state of the policy. If state is Enabled, storageEndpoint and storageAccountAccessKey are required.
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Specifies the blob storage endpoint (e.g. https://MyAccount.blob.core.windows.net). This blob storage will hold all Threat Detection audit logs. If state is Enabled, storageEndpoint is required.
     */
    public val storageEndpoint: Output<String>?
        get() = javaResource.storageEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Specifies whether to use the default server policy.
     */
    public val useServerDefault: Output<String>?
        get() = javaResource.useServerDefault().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object DatabaseThreatDetectionPolicyMapper : ResourceMapper<DatabaseThreatDetectionPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicy::class == javaResource::class

    override fun map(javaResource: Resource): DatabaseThreatDetectionPolicy =
        DatabaseThreatDetectionPolicy(
            javaResource as
                com.pulumi.azurenative.sql.DatabaseThreatDetectionPolicy,
        )
}

/**
 * @see [DatabaseThreatDetectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DatabaseThreatDetectionPolicy].
 */
public suspend fun databaseThreatDetectionPolicy(
    name: String,
    block: suspend DatabaseThreatDetectionPolicyResourceBuilder.() -> Unit,
):
    DatabaseThreatDetectionPolicy {
    val builder = DatabaseThreatDetectionPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DatabaseThreatDetectionPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun databaseThreatDetectionPolicy(name: String): DatabaseThreatDetectionPolicy {
    val builder = DatabaseThreatDetectionPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
