@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.FailoverGroupReadOnlyEndpointResponse
import com.pulumi.azurenative.sql.kotlin.outputs.FailoverGroupReadWriteEndpointResponse
import com.pulumi.azurenative.sql.kotlin.outputs.PartnerInfoResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.sql.kotlin.outputs.FailoverGroupReadOnlyEndpointResponse.Companion.toKotlin as failoverGroupReadOnlyEndpointResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.FailoverGroupReadWriteEndpointResponse.Companion.toKotlin as failoverGroupReadWriteEndpointResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.PartnerInfoResponse.Companion.toKotlin as partnerInfoResponseToKotlin

/**
 * Builder for [FailoverGroup].
 */
@PulumiTagMarker
public class FailoverGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FailoverGroupArgs = FailoverGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FailoverGroupArgsBuilder.() -> Unit) {
        val builder = FailoverGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FailoverGroup {
        val builtJavaResource = com.pulumi.azurenative.sql.FailoverGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FailoverGroup(builtJavaResource)
    }
}

/**
 * A failover group.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create failover group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var failoverGroup = new AzureNative.Sql.FailoverGroup("failoverGroup", new()
 *     {
 *         Databases = new[]
 *         {
 *             "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-1",
 *             "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-2",
 *         },
 *         FailoverGroupName = "failover-group-test-3",
 *         PartnerServers = new[]
 *         {
 *             new AzureNative.Sql.Inputs.PartnerInfoArgs
 *             {
 *                 Id = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-secondary-server",
 *             },
 *         },
 *         ReadOnlyEndpoint = new AzureNative.Sql.Inputs.FailoverGroupReadOnlyEndpointArgs
 *         {
 *             FailoverPolicy = "Disabled",
 *         },
 *         ReadWriteEndpoint = new AzureNative.Sql.Inputs.FailoverGroupReadWriteEndpointArgs
 *         {
 *             FailoverPolicy = "Automatic",
 *             FailoverWithDataLossGracePeriodMinutes = 480,
 *         },
 *         ResourceGroupName = "Default",
 *         ServerName = "failover-group-primary-server",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewFailoverGroup(ctx, "failoverGroup", &sql.FailoverGroupArgs{
 * 			Databases: pulumi.StringArray{
 * 				pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-1"),
 * 				pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-2"),
 * 			},
 * 			FailoverGroupName: pulumi.String("failover-group-test-3"),
 * 			PartnerServers: []sql.PartnerInfoArgs{
 * 				{
 * 					Id: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-secondary-server"),
 * 				},
 * 			},
 * 			ReadOnlyEndpoint: &sql.FailoverGroupReadOnlyEndpointArgs{
 * 				FailoverPolicy: pulumi.String("Disabled"),
 * 			},
 * 			ReadWriteEndpoint: &sql.FailoverGroupReadWriteEndpointArgs{
 * 				FailoverPolicy:                         pulumi.String("Automatic"),
 * 				FailoverWithDataLossGracePeriodMinutes: pulumi.Int(480),
 * 			},
 * 			ResourceGroupName: pulumi.String("Default"),
 * 			ServerName:        pulumi.String("failover-group-primary-server"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.FailoverGroup;
 * import com.pulumi.azurenative.sql.FailoverGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var failoverGroup = new FailoverGroup("failoverGroup", FailoverGroupArgs.builder()
 *             .databases(
 *                 "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-1",
 *                 "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-primary-server/databases/testdb-2")
 *             .failoverGroupName("failover-group-test-3")
 *             .partnerServers(Map.of("id", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/Default/providers/Microsoft.Sql/servers/failover-group-secondary-server"))
 *             .readOnlyEndpoint(Map.of("failoverPolicy", "Disabled"))
 *             .readWriteEndpoint(Map.ofEntries(
 *                 Map.entry("failoverPolicy", "Automatic"),
 *                 Map.entry("failoverWithDataLossGracePeriodMinutes", 480)
 *             ))
 *             .resourceGroupName("Default")
 *             .serverName("failover-group-primary-server")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:FailoverGroup failover-group-test-3 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/failoverGroups/{failoverGroupName}
 * ```
 */
public class FailoverGroup internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.FailoverGroup,
) : KotlinCustomResource(javaResource, FailoverGroupMapper) {
    /**
     * List of databases in the failover group.
     */
    public val databases: Output<List<String>>?
        get() = javaResource.databases().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Resource location.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of partner server information for the failover group.
     */
    public val partnerServers: Output<List<PartnerInfoResponse>>
        get() = javaResource.partnerServers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> partnerInfoResponseToKotlin(args0) })
            })
        })

    /**
     * Read-only endpoint of the failover group instance.
     */
    public val readOnlyEndpoint: Output<FailoverGroupReadOnlyEndpointResponse>?
        get() = javaResource.readOnlyEndpoint().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> failoverGroupReadOnlyEndpointResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Read-write endpoint of the failover group instance.
     */
    public val readWriteEndpoint: Output<FailoverGroupReadWriteEndpointResponse>
        get() = javaResource.readWriteEndpoint().applyValue({ args0 ->
            args0.let({ args0 ->
                failoverGroupReadWriteEndpointResponseToKotlin(args0)
            })
        })

    /**
     * Local replication role of the failover group instance.
     */
    public val replicationRole: Output<String>
        get() = javaResource.replicationRole().applyValue({ args0 -> args0 })

    /**
     * Replication state of the failover group instance.
     */
    public val replicationState: Output<String>
        get() = javaResource.replicationState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FailoverGroupMapper : ResourceMapper<FailoverGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.FailoverGroup::class == javaResource::class

    override fun map(javaResource: Resource): FailoverGroup = FailoverGroup(
        javaResource as
            com.pulumi.azurenative.sql.FailoverGroup,
    )
}

/**
 * @see [FailoverGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FailoverGroup].
 */
public suspend fun failoverGroup(
    name: String,
    block: suspend FailoverGroupResourceBuilder.() -> Unit,
): FailoverGroup {
    val builder = FailoverGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FailoverGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun failoverGroup(name: String): FailoverGroup {
    val builder = FailoverGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
