@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FirewallRule].
 */
@PulumiTagMarker
public class FirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallRuleArgs = FirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallRuleArgsBuilder.() -> Unit) {
        val builder = FirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FirewallRule {
        val builtJavaResource = com.pulumi.azurenative.sql.FirewallRule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FirewallRule(builtJavaResource)
    }
}

/**
 * A server firewall rule.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a firewall rule max/min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.Sql.FirewallRule("firewallRule", new()
 *     {
 *         EndIpAddress = "0.0.0.3",
 *         FirewallRuleName = "firewallrulecrudtest-5370",
 *         ResourceGroupName = "firewallrulecrudtest-12",
 *         ServerName = "firewallrulecrudtest-6285",
 *         StartIpAddress = "0.0.0.3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewFirewallRule(ctx, "firewallRule", &sql.FirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("0.0.0.3"),
 * 			FirewallRuleName:  pulumi.String("firewallrulecrudtest-5370"),
 * 			ResourceGroupName: pulumi.String("firewallrulecrudtest-12"),
 * 			ServerName:        pulumi.String("firewallrulecrudtest-6285"),
 * 			StartIpAddress:    pulumi.String("0.0.0.3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.FirewallRule;
 * import com.pulumi.azurenative.sql.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .endIpAddress("0.0.0.3")
 *             .firewallRuleName("firewallrulecrudtest-5370")
 *             .resourceGroupName("firewallrulecrudtest-12")
 *             .serverName("firewallrulecrudtest-6285")
 *             .startIpAddress("0.0.0.3")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a firewall rule max/min
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.Sql.FirewallRule("firewallRule", new()
 *     {
 *         EndIpAddress = "0.0.0.1",
 *         FirewallRuleName = "firewallrulecrudtest-3927",
 *         ResourceGroupName = "firewallrulecrudtest-12",
 *         ServerName = "firewallrulecrudtest-6285",
 *         StartIpAddress = "0.0.0.1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewFirewallRule(ctx, "firewallRule", &sql.FirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("0.0.0.1"),
 * 			FirewallRuleName:  pulumi.String("firewallrulecrudtest-3927"),
 * 			ResourceGroupName: pulumi.String("firewallrulecrudtest-12"),
 * 			ServerName:        pulumi.String("firewallrulecrudtest-6285"),
 * 			StartIpAddress:    pulumi.String("0.0.0.1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.FirewallRule;
 * import com.pulumi.azurenative.sql.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .endIpAddress("0.0.0.1")
 *             .firewallRuleName("firewallrulecrudtest-3927")
 *             .resourceGroupName("firewallrulecrudtest-12")
 *             .serverName("firewallrulecrudtest-6285")
 *             .startIpAddress("0.0.0.1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:FirewallRule firewallrulecrudtest-3927 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/firewallRules/{firewallRuleName}
 * ```
 */
public class FirewallRule internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.FirewallRule,
) : KotlinCustomResource(javaResource, FirewallRuleMapper) {
    /**
     * The end IP address of the firewall rule. Must be IPv4 format. Must be greater than or equal to startIpAddress. Use value '0.0.0.0' for all Azure-internal IP addresses.
     */
    public val endIpAddress: Output<String>?
        get() = javaResource.endIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>?
        get() = javaResource.name().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The start IP address of the firewall rule. Must be IPv4 format. Use value '0.0.0.0' for all Azure-internal IP addresses.
     */
    public val startIpAddress: Output<String>?
        get() = javaResource.startIpAddress().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallRuleMapper : ResourceMapper<FirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.FirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): FirewallRule = FirewallRule(
        javaResource as
            com.pulumi.azurenative.sql.FirewallRule,
    )
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallRule].
 */
public suspend fun firewallRule(
    name: String,
    block: suspend FirewallRuleResourceBuilder.() -> Unit,
): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallRule(name: String): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
