@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.InstancePoolArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.InstancePoolLicenseType
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.sql.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An Azure SQL instance pool.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create an instance pool with all properties.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instancePool = new AzureNative.Sql.InstancePool("instancePool", new()
 *     {
 *         InstancePoolName = "testIP",
 *         LicenseType = "LicenseIncluded",
 *         Location = "japaneast",
 *         ResourceGroupName = "group1",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Family = "Gen5",
 *             Name = "GP_Gen5",
 *             Tier = "GeneralPurpose",
 *         },
 *         SubnetId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1",
 *         Tags =
 *         {
 *             { "a", "b" },
 *         },
 *         VCores = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewInstancePool(ctx, "instancePool", &sql.InstancePoolArgs{
 * 			InstancePoolName:  pulumi.String("testIP"),
 * 			LicenseType:       pulumi.String("LicenseIncluded"),
 * 			Location:          pulumi.String("japaneast"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Sku: &sql.SkuArgs{
 * 				Family: pulumi.String("Gen5"),
 * 				Name:   pulumi.String("GP_Gen5"),
 * 				Tier:   pulumi.String("GeneralPurpose"),
 * 			},
 * 			SubnetId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1"),
 * 			Tags: pulumi.StringMap{
 * 				"a": pulumi.String("b"),
 * 			},
 * 			VCores: pulumi.Int(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.InstancePool;
 * import com.pulumi.azurenative.sql.InstancePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instancePool = new InstancePool("instancePool", InstancePoolArgs.builder()
 *             .instancePoolName("testIP")
 *             .licenseType("LicenseIncluded")
 *             .location("japaneast")
 *             .resourceGroupName("group1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .subnetId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1")
 *             .tags(Map.of("a", "b"))
 *             .vCores(8)
 *             .build());
 *     }
 * }
 * ```
 * ### Create an instance pool with min properties.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var instancePool = new AzureNative.Sql.InstancePool("instancePool", new()
 *     {
 *         InstancePoolName = "testIP",
 *         LicenseType = "LicenseIncluded",
 *         Location = "japaneast",
 *         ResourceGroupName = "group1",
 *         Sku = new AzureNative.Sql.Inputs.SkuArgs
 *         {
 *             Family = "Gen5",
 *             Name = "GP_Gen5",
 *             Tier = "GeneralPurpose",
 *         },
 *         SubnetId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1",
 *         VCores = 8,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewInstancePool(ctx, "instancePool", &sql.InstancePoolArgs{
 * 			InstancePoolName:  pulumi.String("testIP"),
 * 			LicenseType:       pulumi.String("LicenseIncluded"),
 * 			Location:          pulumi.String("japaneast"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Sku: &sql.SkuArgs{
 * 				Family: pulumi.String("Gen5"),
 * 				Name:   pulumi.String("GP_Gen5"),
 * 				Tier:   pulumi.String("GeneralPurpose"),
 * 			},
 * 			SubnetId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1"),
 * 			VCores:   pulumi.Int(8),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.InstancePool;
 * import com.pulumi.azurenative.sql.InstancePoolArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var instancePool = new InstancePool("instancePool", InstancePoolArgs.builder()
 *             .instancePoolName("testIP")
 *             .licenseType("LicenseIncluded")
 *             .location("japaneast")
 *             .resourceGroupName("group1")
 *             .sku(Map.ofEntries(
 *                 Map.entry("family", "Gen5"),
 *                 Map.entry("name", "GP_Gen5"),
 *                 Map.entry("tier", "GeneralPurpose")
 *             ))
 *             .subnetId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Network/virtualNetworks/myvnet/subnets/mysubnet1")
 *             .vCores(8)
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:InstancePool testIP /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/instancePools/{instancePoolName}
 * ```
 * @property instancePoolName The name of the instance pool to be created or updated.
 * @property licenseType The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price).
 * @property location Resource location.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property sku The name and tier of the SKU.
 * @property subnetId Resource ID of the subnet to place this instance pool in.
 * @property tags Resource tags.
 * @property vCores Count of vCores belonging to this instance pool.
 */
public data class InstancePoolArgs(
    public val instancePoolName: Output<String>? = null,
    public val licenseType: Output<Either<String, InstancePoolLicenseType>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vCores: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.InstancePoolArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.InstancePoolArgs =
        com.pulumi.azurenative.sql.InstancePoolArgs.builder()
            .instancePoolName(instancePoolName?.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vCores(vCores?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstancePoolArgs].
 */
@PulumiTagMarker
public class InstancePoolArgsBuilder internal constructor() {
    private var instancePoolName: Output<String>? = null

    private var licenseType: Output<Either<String, InstancePoolLicenseType>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vCores: Output<Int>? = null

    /**
     * @param value The name of the instance pool to be created or updated.
     */
    @JvmName("lwvfinqlvcsnparo")
    public suspend fun instancePoolName(`value`: Output<String>) {
        this.instancePoolName = value
    }

    /**
     * @param value The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price).
     */
    @JvmName("awvjqxmggwawksib")
    public suspend fun licenseType(`value`: Output<Either<String, InstancePoolLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Resource location.
     */
    @JvmName("kdhxaipfvptrstnl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("urauipouklgfpllf")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name and tier of the SKU.
     */
    @JvmName("lsbyotuhefchxypu")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource ID of the subnet to place this instance pool in.
     */
    @JvmName("gbvovncwjijniyhn")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("grwjkxsdkqroimff")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Count of vCores belonging to this instance pool.
     */
    @JvmName("nydfqordekrjtiex")
    public suspend fun vCores(`value`: Output<Int>) {
        this.vCores = value
    }

    /**
     * @param value The name of the instance pool to be created or updated.
     */
    @JvmName("hhfufhnccmtsmerl")
    public suspend fun instancePoolName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instancePoolName = mapped
    }

    /**
     * @param value The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price).
     */
    @JvmName("mdevokognkasitlw")
    public suspend fun licenseType(`value`: Either<String, InstancePoolLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price).
     */
    @JvmName("biwlmqvuydqxaquv")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InstancePoolLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type. Possible values are 'LicenseIncluded' (price for SQL license is included) and 'BasePrice' (without SQL license price).
     */
    @JvmName("lmrdgnjitgdhslqm")
    public fun licenseType(`value`: InstancePoolLicenseType) {
        val toBeMapped = Either.ofRight<String, InstancePoolLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("ncqcatvwmgejsxge")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ogabkwqwpdbkqsbd")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name and tier of the SKU.
     */
    @JvmName("hhmhqwhfnqnpjvxw")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The name and tier of the SKU.
     */
    @JvmName("nhqiiuwqpqtdcgci")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource ID of the subnet to place this instance pool in.
     */
    @JvmName("ojrarqdqxliqfrcs")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("fxhjbngfoewtmhwb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vaxkjsdgkwvcjiwv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Count of vCores belonging to this instance pool.
     */
    @JvmName("rnkaxnaqxvlgniqv")
    public suspend fun vCores(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vCores = mapped
    }

    internal fun build(): InstancePoolArgs = InstancePoolArgs(
        instancePoolName = instancePoolName,
        licenseType = licenseType,
        location = location,
        resourceGroupName = resourceGroupName,
        sku = sku,
        subnetId = subnetId,
        tags = tags,
        vCores = vCores,
    )
}
