@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.JobArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.JobScheduleArgs
import com.pulumi.azurenative.sql.kotlin.inputs.JobScheduleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A job.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a job with all properties specified
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.Sql.Job("job", new()
 *     {
 *         Description = "my favourite job",
 *         JobAgentName = "agent1",
 *         JobName = "job1",
 *         ResourceGroupName = "group1",
 *         Schedule = new AzureNative.Sql.Inputs.JobScheduleArgs
 *         {
 *             Enabled = true,
 *             EndTime = "2015-09-24T23:59:59Z",
 *             Interval = "PT5M",
 *             StartTime = "2015-09-24T18:30:01Z",
 *             Type = AzureNative.Sql.JobScheduleType.Recurring,
 *         },
 *         ServerName = "server1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJob(ctx, "job", &sql.JobArgs{
 * 			Description:       pulumi.String("my favourite job"),
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			JobName:           pulumi.String("job1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			Schedule: &sql.JobScheduleArgs{
 * 				Enabled:   pulumi.Bool(true),
 * 				EndTime:   pulumi.String("2015-09-24T23:59:59Z"),
 * 				Interval:  pulumi.String("PT5M"),
 * 				StartTime: pulumi.String("2015-09-24T18:30:01Z"),
 * 				Type:      sql.JobScheduleTypeRecurring,
 * 			},
 * 			ServerName: pulumi.String("server1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Job;
 * import com.pulumi.azurenative.sql.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .description("my favourite job")
 *             .jobAgentName("agent1")
 *             .jobName("job1")
 *             .resourceGroupName("group1")
 *             .schedule(Map.ofEntries(
 *                 Map.entry("enabled", true),
 *                 Map.entry("endTime", "2015-09-24T23:59:59Z"),
 *                 Map.entry("interval", "PT5M"),
 *                 Map.entry("startTime", "2015-09-24T18:30:01Z"),
 *                 Map.entry("type", "Recurring")
 *             ))
 *             .serverName("server1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create a job with default properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var job = new AzureNative.Sql.Job("job", new()
 *     {
 *         JobAgentName = "agent1",
 *         JobName = "job1",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJob(ctx, "job", &sql.JobArgs{
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			JobName:           pulumi.String("job1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.Job;
 * import com.pulumi.azurenative.sql.JobArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var job = new Job("job", JobArgs.builder()
 *             .jobAgentName("agent1")
 *             .jobName("job1")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:Job job1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}
 * ```
 * @property description User-defined description of the job.
 * @property jobAgentName The name of the job agent.
 * @property jobName The name of the job to get.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property schedule Schedule properties of the job.
 * @property serverName The name of the server.
 */
public data class JobArgs(
    public val description: Output<String>? = null,
    public val jobAgentName: Output<String>? = null,
    public val jobName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val schedule: Output<JobScheduleArgs>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.JobArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.JobArgs =
        com.pulumi.azurenative.sql.JobArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .jobAgentName(jobAgentName?.applyValue({ args0 -> args0 }))
            .jobName(jobName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobArgs].
 */
@PulumiTagMarker
public class JobArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var jobAgentName: Output<String>? = null

    private var jobName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var schedule: Output<JobScheduleArgs>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value User-defined description of the job.
     */
    @JvmName("ygkdjfqdexmxygeu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the job agent.
     */
    @JvmName("rfchyqiapkcqyoaw")
    public suspend fun jobAgentName(`value`: Output<String>) {
        this.jobAgentName = value
    }

    /**
     * @param value The name of the job to get.
     */
    @JvmName("darxopupipmtwagw")
    public suspend fun jobName(`value`: Output<String>) {
        this.jobName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("synpfdxglffyorcm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Schedule properties of the job.
     */
    @JvmName("ngvtocduxagcnguu")
    public suspend fun schedule(`value`: Output<JobScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("jysrfmtuhrluywbo")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value User-defined description of the job.
     */
    @JvmName("okrxibxvoibjecso")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the job agent.
     */
    @JvmName("ssnqeyhghchsnpjr")
    public suspend fun jobAgentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobAgentName = mapped
    }

    /**
     * @param value The name of the job to get.
     */
    @JvmName("hrhhoahdeayhcslk")
    public suspend fun jobName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("soigyvromkjkdcyo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schedule properties of the job.
     */
    @JvmName("myhrkrhsfdanaaoe")
    public suspend fun schedule(`value`: JobScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument Schedule properties of the job.
     */
    @JvmName("uvpkonsmbmhdgwui")
    public suspend fun schedule(argument: suspend JobScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = JobScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("sssnaaqmuamdxihq")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): JobArgs = JobArgs(
        description = description,
        jobAgentName = jobAgentName,
        jobName = jobName,
        resourceGroupName = resourceGroupName,
        schedule = schedule,
        serverName = serverName,
    )
}
