@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [JobCredential].
 */
@PulumiTagMarker
public class JobCredentialResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobCredentialArgs = JobCredentialArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobCredentialArgsBuilder.() -> Unit) {
        val builder = JobCredentialArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): JobCredential {
        val builtJavaResource = com.pulumi.azurenative.sql.JobCredential(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobCredential(builtJavaResource)
    }
}

/**
 * A stored credential that can be used by a job to connect to target databases.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a credential
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobCredential = new AzureNative.Sql.JobCredential("jobCredential", new()
 *     {
 *         CredentialName = "cred1",
 *         JobAgentName = "agent1",
 *         Password = "<password>",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         Username = "myuser",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobCredential(ctx, "jobCredential", &sql.JobCredentialArgs{
 * 			CredentialName:    pulumi.String("cred1"),
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			Username:          pulumi.String("myuser"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobCredential;
 * import com.pulumi.azurenative.sql.JobCredentialArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobCredential = new JobCredential("jobCredential", JobCredentialArgs.builder()
 *             .credentialName("cred1")
 *             .jobAgentName("agent1")
 *             .password("<password>")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .username("myuser")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobCredential cred1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/credentials/{credentialName}
 * ```
 */
public class JobCredential internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.JobCredential,
) : KotlinCustomResource(javaResource, JobCredentialMapper) {
    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The credential user name.
     */
    public val username: Output<String>
        get() = javaResource.username().applyValue({ args0 -> args0 })
}

public object JobCredentialMapper : ResourceMapper<JobCredential> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.JobCredential::class == javaResource::class

    override fun map(javaResource: Resource): JobCredential = JobCredential(
        javaResource as
            com.pulumi.azurenative.sql.JobCredential,
    )
}

/**
 * @see [JobCredential].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobCredential].
 */
public suspend fun jobCredential(
    name: String,
    block: suspend JobCredentialResourceBuilder.() -> Unit,
): JobCredential {
    val builder = JobCredentialResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobCredential].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobCredential(name: String): JobCredential {
    val builder = JobCredentialResourceBuilder()
    builder.name(name)
    return builder.build()
}
