@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.JobPrivateEndpointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A job agent private endpoint.
 * Azure REST API version: 2023-05-01-preview.
 * ## Example Usage
 * ### Create a private endpoint.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobPrivateEndpoint = new AzureNative.Sql.JobPrivateEndpoint("jobPrivateEndpoint", new()
 *     {
 *         JobAgentName = "agent1",
 *         PrivateEndpointName = "endpoint1",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         TargetServerAzureResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/targetserver1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobPrivateEndpoint(ctx, "jobPrivateEndpoint", &sql.JobPrivateEndpointArgs{
 * 			JobAgentName:                pulumi.String("agent1"),
 * 			PrivateEndpointName:         pulumi.String("endpoint1"),
 * 			ResourceGroupName:           pulumi.String("group1"),
 * 			ServerName:                  pulumi.String("server1"),
 * 			TargetServerAzureResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/targetserver1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobPrivateEndpoint;
 * import com.pulumi.azurenative.sql.JobPrivateEndpointArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobPrivateEndpoint = new JobPrivateEndpoint("jobPrivateEndpoint", JobPrivateEndpointArgs.builder()
 *             .jobAgentName("agent1")
 *             .privateEndpointName("endpoint1")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .targetServerAzureResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/targetserver1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobPrivateEndpoint endpoint1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/privateEndpoints/{privateEndpointName}
 * ```
 * @property jobAgentName The name of the job agent.
 * @property privateEndpointName The name of the private endpoint.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property targetServerAzureResourceId ARM resource id of the server the private endpoint will target.
 */
public data class JobPrivateEndpointArgs(
    public val jobAgentName: Output<String>? = null,
    public val privateEndpointName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val targetServerAzureResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.JobPrivateEndpointArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.JobPrivateEndpointArgs =
        com.pulumi.azurenative.sql.JobPrivateEndpointArgs.builder()
            .jobAgentName(jobAgentName?.applyValue({ args0 -> args0 }))
            .privateEndpointName(privateEndpointName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .targetServerAzureResourceId(targetServerAzureResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobPrivateEndpointArgs].
 */
@PulumiTagMarker
public class JobPrivateEndpointArgsBuilder internal constructor() {
    private var jobAgentName: Output<String>? = null

    private var privateEndpointName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var targetServerAzureResourceId: Output<String>? = null

    /**
     * @param value The name of the job agent.
     */
    @JvmName("slyunkptmwwceyvs")
    public suspend fun jobAgentName(`value`: Output<String>) {
        this.jobAgentName = value
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("avsbmplepkpodejf")
    public suspend fun privateEndpointName(`value`: Output<String>) {
        this.privateEndpointName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ohopemwvayjemaau")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("kxyxqjefpispogsu")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value ARM resource id of the server the private endpoint will target.
     */
    @JvmName("rndpoqdsumrcvjki")
    public suspend fun targetServerAzureResourceId(`value`: Output<String>) {
        this.targetServerAzureResourceId = value
    }

    /**
     * @param value The name of the job agent.
     */
    @JvmName("esscgbduorourtcu")
    public suspend fun jobAgentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobAgentName = mapped
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("jvrhwcicvecnvbdv")
    public suspend fun privateEndpointName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateEndpointName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ushxkynpkqluraed")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("nttvltovawnpuopv")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value ARM resource id of the server the private endpoint will target.
     */
    @JvmName("oumdstsgununaras")
    public suspend fun targetServerAzureResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetServerAzureResourceId = mapped
    }

    internal fun build(): JobPrivateEndpointArgs = JobPrivateEndpointArgs(
        jobAgentName = jobAgentName,
        privateEndpointName = privateEndpointName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        targetServerAzureResourceId = targetServerAzureResourceId,
    )
}
