@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.kotlin.outputs.JobStepActionResponse
import com.pulumi.azurenative.sql.kotlin.outputs.JobStepExecutionOptionsResponse
import com.pulumi.azurenative.sql.kotlin.outputs.JobStepOutputResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.sql.kotlin.outputs.JobStepActionResponse.Companion.toKotlin as jobStepActionResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.JobStepExecutionOptionsResponse.Companion.toKotlin as jobStepExecutionOptionsResponseToKotlin
import com.pulumi.azurenative.sql.kotlin.outputs.JobStepOutputResponse.Companion.toKotlin as jobStepOutputResponseToKotlin

/**
 * Builder for [JobStep].
 */
@PulumiTagMarker
public class JobStepResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: JobStepArgs = JobStepArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend JobStepArgsBuilder.() -> Unit) {
        val builder = JobStepArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): JobStep {
        val builtJavaResource = com.pulumi.azurenative.sql.JobStep(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return JobStep(builtJavaResource)
    }
}

/**
 * A job step.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a job step with all properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobStep = new AzureNative.Sql.JobStep("jobStep", new()
 *     {
 *         Action = new AzureNative.Sql.Inputs.JobStepActionArgs
 *         {
 *             Source = "Inline",
 *             Type = "TSql",
 *             Value = "select 2",
 *         },
 *         Credential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred1",
 *         ExecutionOptions = new AzureNative.Sql.Inputs.JobStepExecutionOptionsArgs
 *         {
 *             InitialRetryIntervalSeconds = 11,
 *             MaximumRetryIntervalSeconds = 222,
 *             RetryAttempts = 42,
 *             RetryIntervalBackoffMultiplier = 3,
 *             TimeoutSeconds = 1234,
 *         },
 *         JobAgentName = "agent1",
 *         JobName = "job1",
 *         Output = new AzureNative.Sql.Inputs.JobStepOutputArgs
 *         {
 *             Credential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0",
 *             DatabaseName = "database3",
 *             ResourceGroupName = "group3",
 *             SchemaName = "myschema1234",
 *             ServerName = "server3",
 *             SubscriptionId = "3501b905-a848-4b5d-96e8-b253f62d735a",
 *             TableName = "mytable5678",
 *             Type = "SqlDatabase",
 *         },
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         StepId = 1,
 *         StepName = "step1",
 *         TargetGroup = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobStep(ctx, "jobStep", &sql.JobStepArgs{
 * 			Action: &sql.JobStepActionArgs{
 * 				Source: pulumi.String("Inline"),
 * 				Type:   pulumi.String("TSql"),
 * 				Value:  pulumi.String("select 2"),
 * 			},
 * 			Credential: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred1"),
 * 			ExecutionOptions: &sql.JobStepExecutionOptionsArgs{
 * 				InitialRetryIntervalSeconds:    pulumi.Int(11),
 * 				MaximumRetryIntervalSeconds:    pulumi.Int(222),
 * 				RetryAttempts:                  pulumi.Int(42),
 * 				RetryIntervalBackoffMultiplier: pulumi.Float64(3),
 * 				TimeoutSeconds:                 pulumi.Int(1234),
 * 			},
 * 			JobAgentName: pulumi.String("agent1"),
 * 			JobName:      pulumi.String("job1"),
 * 			Output: &sql.JobStepOutputTypeArgs{
 * 				Credential:        pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0"),
 * 				DatabaseName:      pulumi.String("database3"),
 * 				ResourceGroupName: pulumi.String("group3"),
 * 				SchemaName:        pulumi.String("myschema1234"),
 * 				ServerName:        pulumi.String("server3"),
 * 				SubscriptionId:    pulumi.String("3501b905-a848-4b5d-96e8-b253f62d735a"),
 * 				TableName:         pulumi.String("mytable5678"),
 * 				Type:              pulumi.String("SqlDatabase"),
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			StepId:            pulumi.Int(1),
 * 			StepName:          pulumi.String("step1"),
 * 			TargetGroup:       pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobStep;
 * import com.pulumi.azurenative.sql.JobStepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobStep = new JobStep("jobStep", JobStepArgs.builder()
 *             .action(Map.ofEntries(
 *                 Map.entry("source", "Inline"),
 *                 Map.entry("type", "TSql"),
 *                 Map.entry("value", "select 2")
 *             ))
 *             .credential("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred1")
 *             .executionOptions(Map.ofEntries(
 *                 Map.entry("initialRetryIntervalSeconds", 11),
 *                 Map.entry("maximumRetryIntervalSeconds", 222),
 *                 Map.entry("retryAttempts", 42),
 *                 Map.entry("retryIntervalBackoffMultiplier", 3),
 *                 Map.entry("timeoutSeconds", 1234)
 *             ))
 *             .jobAgentName("agent1")
 *             .jobName("job1")
 *             .output(Map.ofEntries(
 *                 Map.entry("credential", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0"),
 *                 Map.entry("databaseName", "database3"),
 *                 Map.entry("resourceGroupName", "group3"),
 *                 Map.entry("schemaName", "myschema1234"),
 *                 Map.entry("serverName", "server3"),
 *                 Map.entry("subscriptionId", "3501b905-a848-4b5d-96e8-b253f62d735a"),
 *                 Map.entry("tableName", "mytable5678"),
 *                 Map.entry("type", "SqlDatabase")
 *             ))
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .stepId(1)
 *             .stepName("step1")
 *             .targetGroup("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a job step with minimal properties specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobStep = new AzureNative.Sql.JobStep("jobStep", new()
 *     {
 *         Action = new AzureNative.Sql.Inputs.JobStepActionArgs
 *         {
 *             Value = "select 1",
 *         },
 *         Credential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0",
 *         JobAgentName = "agent1",
 *         JobName = "job1",
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         StepName = "step1",
 *         TargetGroup = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobStep(ctx, "jobStep", &sql.JobStepArgs{
 * 			Action: &sql.JobStepActionArgs{
 * 				Value: pulumi.String("select 1"),
 * 			},
 * 			Credential:        pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0"),
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			JobName:           pulumi.String("job1"),
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			StepName:          pulumi.String("step1"),
 * 			TargetGroup:       pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobStep;
 * import com.pulumi.azurenative.sql.JobStepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobStep = new JobStep("jobStep", JobStepArgs.builder()
 *             .action(Map.of("value", "select 1"))
 *             .credential("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/cred0")
 *             .jobAgentName("agent1")
 *             .jobName("job1")
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .stepName("step1")
 *             .targetGroup("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/targetGroups/targetGroup0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobStep step1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}
 * ```
 */
public class JobStep internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.JobStep,
) : KotlinCustomResource(javaResource, JobStepMapper) {
    /**
     * The action payload of the job step.
     */
    public val action: Output<JobStepActionResponse>
        get() = javaResource.action().applyValue({ args0 ->
            args0.let({ args0 ->
                jobStepActionResponseToKotlin(args0)
            })
        })

    /**
     * The resource ID of the job credential that will be used to connect to the targets.
     */
    public val credential: Output<String>
        get() = javaResource.credential().applyValue({ args0 -> args0 })

    /**
     * Execution options for the job step.
     */
    public val executionOptions: Output<JobStepExecutionOptionsResponse>?
        get() = javaResource.executionOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> jobStepExecutionOptionsResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Output destination properties of the job step.
     */
    public val output: Output<JobStepOutputResponse>?
        get() = javaResource.output().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    jobStepOutputResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The job step's index within the job. If not specified when creating the job step, it will be created as the last step. If not specified when updating the job step, the step id is not modified.
     */
    public val stepId: Output<Int>?
        get() = javaResource.stepId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resource ID of the target group that the job step will be executed on.
     */
    public val targetGroup: Output<String>
        get() = javaResource.targetGroup().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object JobStepMapper : ResourceMapper<JobStep> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.JobStep::class == javaResource::class

    override fun map(javaResource: Resource): JobStep = JobStep(
        javaResource as
            com.pulumi.azurenative.sql.JobStep,
    )
}

/**
 * @see [JobStep].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [JobStep].
 */
public suspend fun jobStep(name: String, block: suspend JobStepResourceBuilder.() -> Unit):
    JobStep {
    val builder = JobStepResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [JobStep].
 * @param name The _unique_ name of the resulting resource.
 */
public fun jobStep(name: String): JobStep {
    val builder = JobStepResourceBuilder()
    builder.name(name)
    return builder.build()
}
