@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.JobTargetGroupArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.JobTargetArgs
import com.pulumi.azurenative.sql.kotlin.inputs.JobTargetArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A group of job targets.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create or update a target group with all properties.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobTargetGroup = new AzureNative.Sql.JobTargetGroup("jobTargetGroup", new()
 *     {
 *         JobAgentName = "agent1",
 *         Members = new[]
 *         {
 *             new AzureNative.Sql.Inputs.JobTargetArgs
 *             {
 *                 DatabaseName = "database1",
 *                 MembershipType = AzureNative.Sql.JobTargetGroupMembershipType.Exclude,
 *                 ServerName = "server1",
 *                 Type = "SqlDatabase",
 *             },
 *             new AzureNative.Sql.Inputs.JobTargetArgs
 *             {
 *                 MembershipType = AzureNative.Sql.JobTargetGroupMembershipType.Include,
 *                 RefreshCredential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential",
 *                 ServerName = "server1",
 *                 Type = "SqlServer",
 *             },
 *             new AzureNative.Sql.Inputs.JobTargetArgs
 *             {
 *                 ElasticPoolName = "pool1",
 *                 MembershipType = AzureNative.Sql.JobTargetGroupMembershipType.Include,
 *                 RefreshCredential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential",
 *                 ServerName = "server2",
 *                 Type = "SqlElasticPool",
 *             },
 *             new AzureNative.Sql.Inputs.JobTargetArgs
 *             {
 *                 MembershipType = AzureNative.Sql.JobTargetGroupMembershipType.Include,
 *                 RefreshCredential = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential",
 *                 ServerName = "server3",
 *                 ShardMapName = "shardMap1",
 *                 Type = "SqlShardMap",
 *             },
 *         },
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         TargetGroupName = "targetGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobTargetGroup(ctx, "jobTargetGroup", &sql.JobTargetGroupArgs{
 * 			JobAgentName: pulumi.String("agent1"),
 * 			Members: []sql.JobTargetArgs{
 * 				{
 * 					DatabaseName:   pulumi.String("database1"),
 * 					MembershipType: sql.JobTargetGroupMembershipTypeExclude,
 * 					ServerName:     pulumi.String("server1"),
 * 					Type:           pulumi.String("SqlDatabase"),
 * 				},
 * 				{
 * 					MembershipType:    sql.JobTargetGroupMembershipTypeInclude,
 * 					RefreshCredential: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 * 					ServerName:        pulumi.String("server1"),
 * 					Type:              pulumi.String("SqlServer"),
 * 				},
 * 				{
 * 					ElasticPoolName:   pulumi.String("pool1"),
 * 					MembershipType:    sql.JobTargetGroupMembershipTypeInclude,
 * 					RefreshCredential: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 * 					ServerName:        pulumi.String("server2"),
 * 					Type:              pulumi.String("SqlElasticPool"),
 * 				},
 * 				{
 * 					MembershipType:    sql.JobTargetGroupMembershipTypeInclude,
 * 					RefreshCredential: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 * 					ServerName:        pulumi.String("server3"),
 * 					ShardMapName:      pulumi.String("shardMap1"),
 * 					Type:              pulumi.String("SqlShardMap"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			TargetGroupName:   pulumi.String("targetGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobTargetGroup;
 * import com.pulumi.azurenative.sql.JobTargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobTargetGroup = new JobTargetGroup("jobTargetGroup", JobTargetGroupArgs.builder()
 *             .jobAgentName("agent1")
 *             .members(
 *                 Map.ofEntries(
 *                     Map.entry("databaseName", "database1"),
 *                     Map.entry("membershipType", "Exclude"),
 *                     Map.entry("serverName", "server1"),
 *                     Map.entry("type", "SqlDatabase")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("membershipType", "Include"),
 *                     Map.entry("refreshCredential", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 *                     Map.entry("serverName", "server1"),
 *                     Map.entry("type", "SqlServer")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("elasticPoolName", "pool1"),
 *                     Map.entry("membershipType", "Include"),
 *                     Map.entry("refreshCredential", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 *                     Map.entry("serverName", "server2"),
 *                     Map.entry("type", "SqlElasticPool")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("membershipType", "Include"),
 *                     Map.entry("refreshCredential", "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/group1/providers/Microsoft.Sql/servers/server1/jobAgents/agent1/credentials/testCredential"),
 *                     Map.entry("serverName", "server3"),
 *                     Map.entry("shardMapName", "shardMap1"),
 *                     Map.entry("type", "SqlShardMap")
 *                 ))
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .targetGroupName("targetGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create or update a target group with minimal properties.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var jobTargetGroup = new AzureNative.Sql.JobTargetGroup("jobTargetGroup", new()
 *     {
 *         JobAgentName = "agent1",
 *         Members = new[] {},
 *         ResourceGroupName = "group1",
 *         ServerName = "server1",
 *         TargetGroupName = "targetGroup1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewJobTargetGroup(ctx, "jobTargetGroup", &sql.JobTargetGroupArgs{
 * 			JobAgentName:      pulumi.String("agent1"),
 * 			Members:           sql.JobTargetArray{},
 * 			ResourceGroupName: pulumi.String("group1"),
 * 			ServerName:        pulumi.String("server1"),
 * 			TargetGroupName:   pulumi.String("targetGroup1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.JobTargetGroup;
 * import com.pulumi.azurenative.sql.JobTargetGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var jobTargetGroup = new JobTargetGroup("jobTargetGroup", JobTargetGroupArgs.builder()
 *             .jobAgentName("agent1")
 *             .members()
 *             .resourceGroupName("group1")
 *             .serverName("server1")
 *             .targetGroupName("targetGroup1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:JobTargetGroup targetGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/targetGroups/{targetGroupName}
 * ```
 * @property jobAgentName The name of the job agent.
 * @property members Members of the target group.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property targetGroupName The name of the target group.
 */
public data class JobTargetGroupArgs(
    public val jobAgentName: Output<String>? = null,
    public val members: Output<List<JobTargetArgs>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val targetGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.JobTargetGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.JobTargetGroupArgs =
        com.pulumi.azurenative.sql.JobTargetGroupArgs.builder()
            .jobAgentName(jobAgentName?.applyValue({ args0 -> args0 }))
            .members(
                members?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .targetGroupName(targetGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobTargetGroupArgs].
 */
@PulumiTagMarker
public class JobTargetGroupArgsBuilder internal constructor() {
    private var jobAgentName: Output<String>? = null

    private var members: Output<List<JobTargetArgs>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var targetGroupName: Output<String>? = null

    /**
     * @param value The name of the job agent.
     */
    @JvmName("whxrgpjjhfnayiuo")
    public suspend fun jobAgentName(`value`: Output<String>) {
        this.jobAgentName = value
    }

    /**
     * @param value Members of the target group.
     */
    @JvmName("rupswnsssxpeggop")
    public suspend fun members(`value`: Output<List<JobTargetArgs>>) {
        this.members = value
    }

    @JvmName("imkgrfvvtmndqwte")
    public suspend fun members(vararg values: Output<JobTargetArgs>) {
        this.members = Output.all(values.asList())
    }

    /**
     * @param values Members of the target group.
     */
    @JvmName("ilhuwtitkducjecq")
    public suspend fun members(values: List<Output<JobTargetArgs>>) {
        this.members = Output.all(values)
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("vhkcjskvcerxqtki")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("virsmfknnoclndlc")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The name of the target group.
     */
    @JvmName("bkggfsmupgbhbyhk")
    public suspend fun targetGroupName(`value`: Output<String>) {
        this.targetGroupName = value
    }

    /**
     * @param value The name of the job agent.
     */
    @JvmName("qejukpofbkbnefrd")
    public suspend fun jobAgentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobAgentName = mapped
    }

    /**
     * @param value Members of the target group.
     */
    @JvmName("hknwtlagjfhqnlik")
    public suspend fun members(`value`: List<JobTargetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param argument Members of the target group.
     */
    @JvmName("taacssjxuwktlwdg")
    public suspend fun members(argument: List<suspend JobTargetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { JobTargetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param argument Members of the target group.
     */
    @JvmName("jpguxxugqssnnfss")
    public suspend fun members(vararg argument: suspend JobTargetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { JobTargetArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param argument Members of the target group.
     */
    @JvmName("qolyjypisdpbrlsf")
    public suspend fun members(argument: suspend JobTargetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(JobTargetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.members = mapped
    }

    /**
     * @param values Members of the target group.
     */
    @JvmName("welceinxeqcfyrlw")
    public suspend fun members(vararg values: JobTargetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.members = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ijpksoykdcdsecvn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("umfvhwggrwrfxmve")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The name of the target group.
     */
    @JvmName("gprhltwyobnxrnnr")
    public suspend fun targetGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetGroupName = mapped
    }

    internal fun build(): JobTargetGroupArgs = JobTargetGroupArgs(
        jobAgentName = jobAgentName,
        members = members,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        targetGroupName = targetGroupName,
    )
}
