@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.OutboundFirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * An Azure SQL DB Server Outbound Firewall Rule.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Approve or reject a outbound firewall rule with a given name.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var outboundFirewallRule = new AzureNative.Sql.OutboundFirewallRule("outboundFirewallRule", new()
 *     {
 *         OutboundRuleFqdn = "server.database.windows.net",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerName = "sqlcrudtest-4645",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewOutboundFirewallRule(ctx, "outboundFirewallRule", &sql.OutboundFirewallRuleArgs{
 * 			OutboundRuleFqdn:  pulumi.String("server.database.windows.net"),
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-7398"),
 * 			ServerName:        pulumi.String("sqlcrudtest-4645"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.OutboundFirewallRule;
 * import com.pulumi.azurenative.sql.OutboundFirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var outboundFirewallRule = new OutboundFirewallRule("outboundFirewallRule", OutboundFirewallRuleArgs.builder()
 *             .outboundRuleFqdn("server.database.windows.net")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverName("sqlcrudtest-4645")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:OutboundFirewallRule server.database.windows.net /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/outboundFirewallRules/{outboundRuleFqdn}
 * ```
 * @property outboundRuleFqdn
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class OutboundFirewallRuleArgs(
    public val outboundRuleFqdn: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.OutboundFirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.OutboundFirewallRuleArgs =
        com.pulumi.azurenative.sql.OutboundFirewallRuleArgs.builder()
            .outboundRuleFqdn(outboundRuleFqdn?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OutboundFirewallRuleArgs].
 */
@PulumiTagMarker
public class OutboundFirewallRuleArgsBuilder internal constructor() {
    private var outboundRuleFqdn: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("wamwibpkobhumgpf")
    public suspend fun outboundRuleFqdn(`value`: Output<String>) {
        this.outboundRuleFqdn = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("nfsilaxjwfonpswn")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("mlmddnwmcsvywytk")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value
     */
    @JvmName("nhxlpxsojgjiwcuc")
    public suspend fun outboundRuleFqdn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.outboundRuleFqdn = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("smxshdubuujdjbth")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("pdfahgtbymabaawc")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    internal fun build(): OutboundFirewallRuleArgs = OutboundFirewallRuleArgs(
        outboundRuleFqdn = outboundRuleFqdn,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
    )
}
