@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SensitivityLabel].
 */
@PulumiTagMarker
public class SensitivityLabelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SensitivityLabelArgs = SensitivityLabelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SensitivityLabelArgsBuilder.() -> Unit) {
        val builder = SensitivityLabelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SensitivityLabel {
        val builtJavaResource = com.pulumi.azurenative.sql.SensitivityLabel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SensitivityLabel(builtJavaResource)
    }
}

/**
 * A sensitivity label.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Updates the sensitivity label of a given column with all parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sensitivityLabel = new AzureNative.Sql.SensitivityLabel("sensitivityLabel", new()
 *     {
 *         ColumnName = "myColumn",
 *         DatabaseName = "myDatabase",
 *         InformationType = "PhoneNumber",
 *         InformationTypeId = "d22fa6e9-5ee4-3bde-4c2b-a409604c4646",
 *         LabelId = "bf91e08c-f4f0-478a-b016-25164b2a65ff",
 *         LabelName = "PII",
 *         Rank = AzureNative.Sql.SensitivityLabelRank.Low,
 *         ResourceGroupName = "myRG",
 *         SchemaName = "dbo",
 *         SensitivityLabelSource = "current",
 *         ServerName = "myServer",
 *         TableName = "myTable",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSensitivityLabel(ctx, "sensitivityLabel", &sql.SensitivityLabelArgs{
 * 			ColumnName:             pulumi.String("myColumn"),
 * 			DatabaseName:           pulumi.String("myDatabase"),
 * 			InformationType:        pulumi.String("PhoneNumber"),
 * 			InformationTypeId:      pulumi.String("d22fa6e9-5ee4-3bde-4c2b-a409604c4646"),
 * 			LabelId:                pulumi.String("bf91e08c-f4f0-478a-b016-25164b2a65ff"),
 * 			LabelName:              pulumi.String("PII"),
 * 			Rank:                   sql.SensitivityLabelRankLow,
 * 			ResourceGroupName:      pulumi.String("myRG"),
 * 			SchemaName:             pulumi.String("dbo"),
 * 			SensitivityLabelSource: pulumi.String("current"),
 * 			ServerName:             pulumi.String("myServer"),
 * 			TableName:              pulumi.String("myTable"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SensitivityLabel;
 * import com.pulumi.azurenative.sql.SensitivityLabelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sensitivityLabel = new SensitivityLabel("sensitivityLabel", SensitivityLabelArgs.builder()
 *             .columnName("myColumn")
 *             .databaseName("myDatabase")
 *             .informationType("PhoneNumber")
 *             .informationTypeId("d22fa6e9-5ee4-3bde-4c2b-a409604c4646")
 *             .labelId("bf91e08c-f4f0-478a-b016-25164b2a65ff")
 *             .labelName("PII")
 *             .rank("Low")
 *             .resourceGroupName("myRG")
 *             .schemaName("dbo")
 *             .sensitivityLabelSource("current")
 *             .serverName("myServer")
 *             .tableName("myTable")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:SensitivityLabel current /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/schemas/{schemaName}/tables/{tableName}/columns/{columnName}/sensitivityLabels/{sensitivityLabelSource}
 * ```
 */
public class SensitivityLabel internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.SensitivityLabel,
) : KotlinCustomResource(javaResource, SensitivityLabelMapper) {
    /**
     * The column name.
     */
    public val columnName: Output<String>
        get() = javaResource.columnName().applyValue({ args0 -> args0 })

    /**
     * The information type.
     */
    public val informationType: Output<String>?
        get() = javaResource.informationType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The information type ID.
     */
    public val informationTypeId: Output<String>?
        get() = javaResource.informationTypeId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not.
     */
    public val isDisabled: Output<Boolean>
        get() = javaResource.isDisabled().applyValue({ args0 -> args0 })

    /**
     * The label ID.
     */
    public val labelId: Output<String>?
        get() = javaResource.labelId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The label name.
     */
    public val labelName: Output<String>?
        get() = javaResource.labelName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource that manages the sensitivity label.
     */
    public val managedBy: Output<String>
        get() = javaResource.managedBy().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val rank: Output<String>?
        get() = javaResource.rank().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The schema name.
     */
    public val schemaName: Output<String>
        get() = javaResource.schemaName().applyValue({ args0 -> args0 })

    /**
     * The table name.
     */
    public val tableName: Output<String>
        get() = javaResource.tableName().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SensitivityLabelMapper : ResourceMapper<SensitivityLabel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.SensitivityLabel::class == javaResource::class

    override fun map(javaResource: Resource): SensitivityLabel = SensitivityLabel(
        javaResource as
            com.pulumi.azurenative.sql.SensitivityLabel,
    )
}

/**
 * @see [SensitivityLabel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SensitivityLabel].
 */
public suspend fun sensitivityLabel(
    name: String,
    block: suspend SensitivityLabelResourceBuilder.() -> Unit,
): SensitivityLabel {
    val builder = SensitivityLabelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SensitivityLabel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun sensitivityLabel(name: String): SensitivityLabel {
    val builder = SensitivityLabelResourceBuilder()
    builder.name(name)
    return builder.build()
}
