@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ServerAzureADAdministratorArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.AdministratorType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure Active Directory administrator.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2014-04-01, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Creates or updates an existing Azure Active Directory administrator.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverAzureADAdministrator = new AzureNative.Sql.ServerAzureADAdministrator("serverAzureADAdministrator", new()
 *     {
 *         AdministratorName = "ActiveDirectory",
 *         AdministratorType = "ActiveDirectory",
 *         Login = "bob@contoso.com",
 *         ResourceGroupName = "sqlcrudtest-4799",
 *         ServerName = "sqlcrudtest-6440",
 *         Sid = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *         TenantId = "c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerAzureADAdministrator(ctx, "serverAzureADAdministrator", &sql.ServerAzureADAdministratorArgs{
 * 			AdministratorName: pulumi.String("ActiveDirectory"),
 * 			AdministratorType: pulumi.String("ActiveDirectory"),
 * 			Login:             pulumi.String("bob@contoso.com"),
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-4799"),
 * 			ServerName:        pulumi.String("sqlcrudtest-6440"),
 * 			Sid:               pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 			TenantId:          pulumi.String("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerAzureADAdministrator;
 * import com.pulumi.azurenative.sql.ServerAzureADAdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverAzureADAdministrator = new ServerAzureADAdministrator("serverAzureADAdministrator", ServerAzureADAdministratorArgs.builder()
 *             .administratorName("ActiveDirectory")
 *             .administratorType("ActiveDirectory")
 *             .login("bob@contoso.com")
 *             .resourceGroupName("sqlcrudtest-4799")
 *             .serverName("sqlcrudtest-6440")
 *             .sid("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .tenantId("c6b82b90-a647-49cb-8a62-0d2d3cb7ac7c")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerAzureADAdministrator ActiveDirectory /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/administrators/{administratorName}
 * ```
 * @property administratorName The name of server active directory administrator.
 * @property administratorType Type of the sever administrator.
 * @property login Login name of the server administrator.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property sid SID (object ID) of the server administrator.
 * @property tenantId Tenant ID of the administrator.
 */
public data class ServerAzureADAdministratorArgs(
    public val administratorName: Output<String>? = null,
    public val administratorType: Output<Either<String, AdministratorType>>? = null,
    public val login: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val sid: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ServerAzureADAdministratorArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ServerAzureADAdministratorArgs =
        com.pulumi.azurenative.sql.ServerAzureADAdministratorArgs.builder()
            .administratorName(administratorName?.applyValue({ args0 -> args0 }))
            .administratorType(
                administratorType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .login(login?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .sid(sid?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerAzureADAdministratorArgs].
 */
@PulumiTagMarker
public class ServerAzureADAdministratorArgsBuilder internal constructor() {
    private var administratorName: Output<String>? = null

    private var administratorType: Output<Either<String, AdministratorType>>? = null

    private var login: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var sid: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value The name of server active directory administrator.
     */
    @JvmName("vbvshgvvaowtwxht")
    public suspend fun administratorName(`value`: Output<String>) {
        this.administratorName = value
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("tsbuiccscedvtndt")
    public suspend fun administratorType(`value`: Output<Either<String, AdministratorType>>) {
        this.administratorType = value
    }

    /**
     * @param value Login name of the server administrator.
     */
    @JvmName("ixeyepofwjlyqacv")
    public suspend fun login(`value`: Output<String>) {
        this.login = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("lrnerfmxfamwnjib")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("qumhundpujksgsmc")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value SID (object ID) of the server administrator.
     */
    @JvmName("dacnkauwjhrcxvue")
    public suspend fun sid(`value`: Output<String>) {
        this.sid = value
    }

    /**
     * @param value Tenant ID of the administrator.
     */
    @JvmName("uivknfgsnohklbva")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value The name of server active directory administrator.
     */
    @JvmName("ucaekggydirekhtb")
    public suspend fun administratorName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorName = mapped
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("vnyhjikeqqocepdv")
    public suspend fun administratorType(`value`: Either<String, AdministratorType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("mtjafoonynnmside")
    public fun administratorType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AdministratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Type of the sever administrator.
     */
    @JvmName("cfumesubichxutkx")
    public fun administratorType(`value`: AdministratorType) {
        val toBeMapped = Either.ofRight<String, AdministratorType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorType = mapped
    }

    /**
     * @param value Login name of the server administrator.
     */
    @JvmName("mmnsykfqoebmflop")
    public suspend fun login(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.login = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gfybrjlqfjrvofoj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("xejysekvfvaksxjk")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value SID (object ID) of the server administrator.
     */
    @JvmName("qkuotbvpoumlcfnq")
    public suspend fun sid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    /**
     * @param value Tenant ID of the administrator.
     */
    @JvmName("opyakihbnhptygph")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): ServerAzureADAdministratorArgs = ServerAzureADAdministratorArgs(
        administratorName = administratorName,
        administratorType = administratorType,
        login = login,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        sid = sid,
        tenantId = tenantId,
    )
}
