@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ServerAzureADOnlyAuthentication].
 */
@PulumiTagMarker
public class ServerAzureADOnlyAuthenticationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServerAzureADOnlyAuthenticationArgs = ServerAzureADOnlyAuthenticationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServerAzureADOnlyAuthenticationArgsBuilder.() -> Unit) {
        val builder = ServerAzureADOnlyAuthenticationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServerAzureADOnlyAuthentication {
        val builtJavaResource =
            com.pulumi.azurenative.sql.ServerAzureADOnlyAuthentication(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServerAzureADOnlyAuthentication(builtJavaResource)
    }
}

/**
 * Azure Active Directory only authentication.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Creates or updates Azure Active Directory only authentication object.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverAzureADOnlyAuthentication = new AzureNative.Sql.ServerAzureADOnlyAuthentication("serverAzureADOnlyAuthentication", new()
 *     {
 *         AuthenticationName = "Default",
 *         AzureADOnlyAuthentication = false,
 *         ResourceGroupName = "sqlcrudtest-4799",
 *         ServerName = "sqlcrudtest-6440",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerAzureADOnlyAuthentication(ctx, "serverAzureADOnlyAuthentication", &sql.ServerAzureADOnlyAuthenticationArgs{
 * 			AuthenticationName:        pulumi.String("Default"),
 * 			AzureADOnlyAuthentication: pulumi.Bool(false),
 * 			ResourceGroupName:         pulumi.String("sqlcrudtest-4799"),
 * 			ServerName:                pulumi.String("sqlcrudtest-6440"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerAzureADOnlyAuthentication;
 * import com.pulumi.azurenative.sql.ServerAzureADOnlyAuthenticationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverAzureADOnlyAuthentication = new ServerAzureADOnlyAuthentication("serverAzureADOnlyAuthentication", ServerAzureADOnlyAuthenticationArgs.builder()
 *             .authenticationName("Default")
 *             .azureADOnlyAuthentication(false)
 *             .resourceGroupName("sqlcrudtest-4799")
 *             .serverName("sqlcrudtest-6440")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerAzureADOnlyAuthentication Default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/azureADOnlyAuthentications/{authenticationName}
 * ```
 */
public class ServerAzureADOnlyAuthentication internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.ServerAzureADOnlyAuthentication,
) : KotlinCustomResource(javaResource, ServerAzureADOnlyAuthenticationMapper) {
    /**
     * Azure Active Directory only Authentication enabled.
     */
    public val azureADOnlyAuthentication: Output<Boolean>
        get() = javaResource.azureADOnlyAuthentication().applyValue({ args0 -> args0 })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServerAzureADOnlyAuthenticationMapper :
    ResourceMapper<ServerAzureADOnlyAuthentication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.ServerAzureADOnlyAuthentication::class == javaResource::class

    override fun map(javaResource: Resource): ServerAzureADOnlyAuthentication =
        ServerAzureADOnlyAuthentication(
            javaResource as
                com.pulumi.azurenative.sql.ServerAzureADOnlyAuthentication,
        )
}

/**
 * @see [ServerAzureADOnlyAuthentication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServerAzureADOnlyAuthentication].
 */
public suspend fun serverAzureADOnlyAuthentication(
    name: String,
    block: suspend ServerAzureADOnlyAuthenticationResourceBuilder.() -> Unit,
):
    ServerAzureADOnlyAuthentication {
    val builder = ServerAzureADOnlyAuthenticationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServerAzureADOnlyAuthentication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serverAzureADOnlyAuthentication(name: String): ServerAzureADOnlyAuthentication {
    val builder = ServerAzureADOnlyAuthenticationResourceBuilder()
    builder.name(name)
    return builder.build()
}
