@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.ServerKeyArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.ServerKeyType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A server key.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2015-05-01-preview, 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Creates or updates a server key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serverKey = new AzureNative.Sql.ServerKey("serverKey", new()
 *     {
 *         KeyName = "someVault_someKey_01234567890123456789012345678901",
 *         ResourceGroupName = "sqlcrudtest-7398",
 *         ServerKeyType = "AzureKeyVault",
 *         ServerName = "sqlcrudtest-4645",
 *         Uri = "https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewServerKey(ctx, "serverKey", &sql.ServerKeyArgs{
 * 			KeyName:           pulumi.String("someVault_someKey_01234567890123456789012345678901"),
 * 			ResourceGroupName: pulumi.String("sqlcrudtest-7398"),
 * 			ServerKeyType:     pulumi.String("AzureKeyVault"),
 * 			ServerName:        pulumi.String("sqlcrudtest-4645"),
 * 			Uri:               pulumi.String("https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.ServerKey;
 * import com.pulumi.azurenative.sql.ServerKeyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serverKey = new ServerKey("serverKey", ServerKeyArgs.builder()
 *             .keyName("someVault_someKey_01234567890123456789012345678901")
 *             .resourceGroupName("sqlcrudtest-7398")
 *             .serverKeyType("AzureKeyVault")
 *             .serverName("sqlcrudtest-4645")
 *             .uri("https://someVault.vault.azure.net/keys/someKey/01234567890123456789012345678901")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:ServerKey sqlcrudtest-4645 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/keys/{keyName}
 * ```
 * @property keyName The name of the server key to be operated on (updated or created). The key name is required to be in the format of 'vault_key_version'. For example, if the keyId is https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion, then the server key name should be formatted as: YourVaultName_YourKeyName_YourKeyVersion
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverKeyType The server key type like 'ServiceManaged', 'AzureKeyVault'.
 * @property serverName The name of the server.
 * @property uri The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is required. The AKV URI is required to be in this format: 'https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion'
 */
public data class ServerKeyArgs(
    public val keyName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverKeyType: Output<Either<String, ServerKeyType>>? = null,
    public val serverName: Output<String>? = null,
    public val uri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.ServerKeyArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.ServerKeyArgs =
        com.pulumi.azurenative.sql.ServerKeyArgs.builder()
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverKeyType(
                serverKeyType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .uri(uri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServerKeyArgs].
 */
@PulumiTagMarker
public class ServerKeyArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverKeyType: Output<Either<String, ServerKeyType>>? = null

    private var serverName: Output<String>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The name of the server key to be operated on (updated or created). The key name is required to be in the format of 'vault_key_version'. For example, if the keyId is https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion, then the server key name should be formatted as: YourVaultName_YourKeyName_YourKeyVersion
     */
    @JvmName("asbgoenljvfoqhxe")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("qpssgiqulqmjfxol")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The server key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("uakbihjxveljogvt")
    public suspend fun serverKeyType(`value`: Output<Either<String, ServerKeyType>>) {
        this.serverKeyType = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ftxwmuygmevqmstc")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is required. The AKV URI is required to be in this format: 'https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion'
     */
    @JvmName("kvufapkgcjcjpppr")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The name of the server key to be operated on (updated or created). The key name is required to be in the format of 'vault_key_version'. For example, if the keyId is https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion, then the server key name should be formatted as: YourVaultName_YourKeyName_YourKeyVersion
     */
    @JvmName("ykcsbesclwtcmqua")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("jpktnflfxfuyrnlk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The server key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("pnuammtmfsdrebtu")
    public suspend fun serverKeyType(`value`: Either<String, ServerKeyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverKeyType = mapped
    }

    /**
     * @param value The server key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("cdcvxlcugayqyxek")
    public fun serverKeyType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverKeyType = mapped
    }

    /**
     * @param value The server key type like 'ServiceManaged', 'AzureKeyVault'.
     */
    @JvmName("qgadaygmwjtfavrh")
    public fun serverKeyType(`value`: ServerKeyType) {
        val toBeMapped = Either.ofRight<String, ServerKeyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverKeyType = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("iskaorsqbbbkrjft")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The URI of the server key. If the ServerKeyType is AzureKeyVault, then the URI is required. The AKV URI is required to be in this format: 'https://YourVaultName.vault.azure.net/keys/YourKeyName/YourKeyVersion'
     */
    @JvmName("uipnhinlfyfjjmvp")
    public suspend fun uri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): ServerKeyArgs = ServerKeyArgs(
        keyName = keyName,
        resourceGroupName = resourceGroupName,
        serverKeyType = serverKeyType,
        serverName = serverName,
        uri = uri,
    )
}
