@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.azurenative.sql.StartStopManagedInstanceScheduleArgs.builder
import com.pulumi.azurenative.sql.kotlin.inputs.ScheduleItemArgs
import com.pulumi.azurenative.sql.kotlin.inputs.ScheduleItemArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Managed instance's Start/Stop schedule.
 * Azure REST API version: 2022-11-01-preview.
 * Other available API versions: 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Creates or updates the managed instance's Start/Stop schedule with all optional parameters specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var startStopManagedInstanceSchedule = new AzureNative.Sql.StartStopManagedInstanceSchedule("startStopManagedInstanceSchedule", new()
 *     {
 *         Description = "This is a schedule for our Dev/Test environment.",
 *         ManagedInstanceName = "schedulemi",
 *         ResourceGroupName = "schedulerg",
 *         ScheduleList = new[]
 *         {
 *             new AzureNative.Sql.Inputs.ScheduleItemArgs
 *             {
 *                 StartDay = "Thursday",
 *                 StartTime = "18:00",
 *                 StopDay = "Thursday",
 *                 StopTime = "17:00",
 *             },
 *             new AzureNative.Sql.Inputs.ScheduleItemArgs
 *             {
 *                 StartDay = "Thursday",
 *                 StartTime = "15:00",
 *                 StopDay = "Thursday",
 *                 StopTime = "14:00",
 *             },
 *         },
 *         StartStopScheduleName = "default",
 *         TimeZoneId = "Central European Standard Time",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewStartStopManagedInstanceSchedule(ctx, "startStopManagedInstanceSchedule", &sql.StartStopManagedInstanceScheduleArgs{
 * 			Description:         pulumi.String("This is a schedule for our Dev/Test environment."),
 * 			ManagedInstanceName: pulumi.String("schedulemi"),
 * 			ResourceGroupName:   pulumi.String("schedulerg"),
 * 			ScheduleList: []sql.ScheduleItemArgs{
 * 				{
 * 					StartDay:  pulumi.String("Thursday"),
 * 					StartTime: pulumi.String("18:00"),
 * 					StopDay:   pulumi.String("Thursday"),
 * 					StopTime:  pulumi.String("17:00"),
 * 				},
 * 				{
 * 					StartDay:  pulumi.String("Thursday"),
 * 					StartTime: pulumi.String("15:00"),
 * 					StopDay:   pulumi.String("Thursday"),
 * 					StopTime:  pulumi.String("14:00"),
 * 				},
 * 			},
 * 			StartStopScheduleName: pulumi.String("default"),
 * 			TimeZoneId:            pulumi.String("Central European Standard Time"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.StartStopManagedInstanceSchedule;
 * import com.pulumi.azurenative.sql.StartStopManagedInstanceScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var startStopManagedInstanceSchedule = new StartStopManagedInstanceSchedule("startStopManagedInstanceSchedule", StartStopManagedInstanceScheduleArgs.builder()
 *             .description("This is a schedule for our Dev/Test environment.")
 *             .managedInstanceName("schedulemi")
 *             .resourceGroupName("schedulerg")
 *             .scheduleList(
 *                 Map.ofEntries(
 *                     Map.entry("startDay", "Thursday"),
 *                     Map.entry("startTime", "18:00"),
 *                     Map.entry("stopDay", "Thursday"),
 *                     Map.entry("stopTime", "17:00")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("startDay", "Thursday"),
 *                     Map.entry("startTime", "15:00"),
 *                     Map.entry("stopDay", "Thursday"),
 *                     Map.entry("stopTime", "14:00")
 *                 ))
 *             .startStopScheduleName("default")
 *             .timeZoneId("Central European Standard Time")
 *             .build());
 *     }
 * }
 * ```
 * ### Creates or updates the managed instance's Start/Stop schedule with no optional parameters specified.
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var startStopManagedInstanceSchedule = new AzureNative.Sql.StartStopManagedInstanceSchedule("startStopManagedInstanceSchedule", new()
 *     {
 *         ManagedInstanceName = "schedulemi",
 *         ResourceGroupName = "schedulerg",
 *         ScheduleList = new[]
 *         {
 *             new AzureNative.Sql.Inputs.ScheduleItemArgs
 *             {
 *                 StartDay = "Thursday",
 *                 StartTime = "18:00",
 *                 StopDay = "Thursday",
 *                 StopTime = "17:00",
 *             },
 *             new AzureNative.Sql.Inputs.ScheduleItemArgs
 *             {
 *                 StartDay = "Thursday",
 *                 StartTime = "15:00",
 *                 StopDay = "Thursday",
 *                 StopTime = "14:00",
 *             },
 *         },
 *         StartStopScheduleName = "default",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewStartStopManagedInstanceSchedule(ctx, "startStopManagedInstanceSchedule", &sql.StartStopManagedInstanceScheduleArgs{
 * 			ManagedInstanceName: pulumi.String("schedulemi"),
 * 			ResourceGroupName:   pulumi.String("schedulerg"),
 * 			ScheduleList: []sql.ScheduleItemArgs{
 * 				{
 * 					StartDay:  pulumi.String("Thursday"),
 * 					StartTime: pulumi.String("18:00"),
 * 					StopDay:   pulumi.String("Thursday"),
 * 					StopTime:  pulumi.String("17:00"),
 * 				},
 * 				{
 * 					StartDay:  pulumi.String("Thursday"),
 * 					StartTime: pulumi.String("15:00"),
 * 					StopDay:   pulumi.String("Thursday"),
 * 					StopTime:  pulumi.String("14:00"),
 * 				},
 * 			},
 * 			StartStopScheduleName: pulumi.String("default"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.StartStopManagedInstanceSchedule;
 * import com.pulumi.azurenative.sql.StartStopManagedInstanceScheduleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var startStopManagedInstanceSchedule = new StartStopManagedInstanceSchedule("startStopManagedInstanceSchedule", StartStopManagedInstanceScheduleArgs.builder()
 *             .managedInstanceName("schedulemi")
 *             .resourceGroupName("schedulerg")
 *             .scheduleList(
 *                 Map.ofEntries(
 *                     Map.entry("startDay", "Thursday"),
 *                     Map.entry("startTime", "18:00"),
 *                     Map.entry("stopDay", "Thursday"),
 *                     Map.entry("stopTime", "17:00")
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("startDay", "Thursday"),
 *                     Map.entry("startTime", "15:00"),
 *                     Map.entry("stopDay", "Thursday"),
 *                     Map.entry("stopTime", "14:00")
 *                 ))
 *             .startStopScheduleName("default")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:StartStopManagedInstanceSchedule default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/startStopSchedules/{startStopScheduleName}
 * ```
 * @property description The description of the schedule.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property scheduleList Schedule list.
 * @property startStopScheduleName Name of the managed instance Start/Stop schedule.
 * @property timeZoneId The time zone of the schedule.
 */
public data class StartStopManagedInstanceScheduleArgs(
    public val description: Output<String>? = null,
    public val managedInstanceName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val scheduleList: Output<List<ScheduleItemArgs>>? = null,
    public val startStopScheduleName: Output<String>? = null,
    public val timeZoneId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.StartStopManagedInstanceScheduleArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.StartStopManagedInstanceScheduleArgs =
        com.pulumi.azurenative.sql.StartStopManagedInstanceScheduleArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .scheduleList(
                scheduleList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .startStopScheduleName(startStopScheduleName?.applyValue({ args0 -> args0 }))
            .timeZoneId(timeZoneId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StartStopManagedInstanceScheduleArgs].
 */
@PulumiTagMarker
public class StartStopManagedInstanceScheduleArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var managedInstanceName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var scheduleList: Output<List<ScheduleItemArgs>>? = null

    private var startStopScheduleName: Output<String>? = null

    private var timeZoneId: Output<String>? = null

    /**
     * @param value The description of the schedule.
     */
    @JvmName("ieedkcmgdxwxakwm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("gqoinhykabwwyjua")
    public suspend fun managedInstanceName(`value`: Output<String>) {
        this.managedInstanceName = value
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("sbkfkbaelwyeaxbg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Schedule list.
     */
    @JvmName("gcmiglbnglaldslo")
    public suspend fun scheduleList(`value`: Output<List<ScheduleItemArgs>>) {
        this.scheduleList = value
    }

    @JvmName("hclandousfpodphf")
    public suspend fun scheduleList(vararg values: Output<ScheduleItemArgs>) {
        this.scheduleList = Output.all(values.asList())
    }

    /**
     * @param values Schedule list.
     */
    @JvmName("xhnacqlmqivthxyx")
    public suspend fun scheduleList(values: List<Output<ScheduleItemArgs>>) {
        this.scheduleList = Output.all(values)
    }

    /**
     * @param value Name of the managed instance Start/Stop schedule.
     */
    @JvmName("okfifcxvgvxtoryu")
    public suspend fun startStopScheduleName(`value`: Output<String>) {
        this.startStopScheduleName = value
    }

    /**
     * @param value The time zone of the schedule.
     */
    @JvmName("ctfugylgwtqpidoc")
    public suspend fun timeZoneId(`value`: Output<String>) {
        this.timeZoneId = value
    }

    /**
     * @param value The description of the schedule.
     */
    @JvmName("dvjsrdmmsldgdjfm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("kddkmirgyqwelamv")
    public suspend fun managedInstanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("gkttsccbipnnqelm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Schedule list.
     */
    @JvmName("ydpcmkhhehxlsuro")
    public suspend fun scheduleList(`value`: List<ScheduleItemArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleList = mapped
    }

    /**
     * @param argument Schedule list.
     */
    @JvmName("jlfanebxqahgatni")
    public suspend fun scheduleList(argument: List<suspend ScheduleItemArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScheduleItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scheduleList = mapped
    }

    /**
     * @param argument Schedule list.
     */
    @JvmName("laxbiyqthxbwekah")
    public suspend fun scheduleList(vararg argument: suspend ScheduleItemArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScheduleItemArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scheduleList = mapped
    }

    /**
     * @param argument Schedule list.
     */
    @JvmName("maxkhewqjvvdptdm")
    public suspend fun scheduleList(argument: suspend ScheduleItemArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScheduleItemArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scheduleList = mapped
    }

    /**
     * @param values Schedule list.
     */
    @JvmName("jygmvssomwjupbty")
    public suspend fun scheduleList(vararg values: ScheduleItemArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheduleList = mapped
    }

    /**
     * @param value Name of the managed instance Start/Stop schedule.
     */
    @JvmName("idybkvsexxplvsjr")
    public suspend fun startStopScheduleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startStopScheduleName = mapped
    }

    /**
     * @param value The time zone of the schedule.
     */
    @JvmName("qicgvbtwtqnxvlrg")
    public suspend fun timeZoneId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeZoneId = mapped
    }

    internal fun build(): StartStopManagedInstanceScheduleArgs = StartStopManagedInstanceScheduleArgs(
        description = description,
        managedInstanceName = managedInstanceName,
        resourceGroupName = resourceGroupName,
        scheduleList = scheduleList,
        startStopScheduleName = startStopScheduleName,
        timeZoneId = timeZoneId,
    )
}
