@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SyncMember].
 */
@PulumiTagMarker
public class SyncMemberResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SyncMemberArgs = SyncMemberArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SyncMemberArgsBuilder.() -> Unit) {
        val builder = SyncMemberArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): SyncMember {
        val builtJavaResource = com.pulumi.azurenative.sql.SyncMember(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return SyncMember(builtJavaResource)
    }
}

/**
 * An Azure SQL Database sync member.
 * Azure REST API version: 2021-11-01. Prior API version in Azure Native 1.x: 2020-11-01-preview.
 * Other available API versions: 2022-11-01-preview, 2023-02-01-preview, 2023-05-01-preview.
 * ## Example Usage
 * ### Create a new sync member
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncMember = new AzureNative.Sql.SyncMember("syncMember", new()
 *     {
 *         DatabaseName = "syncgroupcrud-7421",
 *         DatabaseType = "AzureSqlDatabase",
 *         ResourceGroupName = "syncgroupcrud-65440",
 *         ServerName = "syncgroupcrud-8475",
 *         SyncDirection = "Bidirectional",
 *         SyncGroupName = "syncgroupcrud-3187",
 *         SyncMemberAzureDatabaseResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328",
 *         SyncMemberName = "syncmembercrud-4879",
 *         UsePrivateLinkConnection = true,
 *         UserName = "myUser",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncMember(ctx, "syncMember", &sql.SyncMemberArgs{
 * 			DatabaseName:                      pulumi.String("syncgroupcrud-7421"),
 * 			DatabaseType:                      pulumi.String("AzureSqlDatabase"),
 * 			ResourceGroupName:                 pulumi.String("syncgroupcrud-65440"),
 * 			ServerName:                        pulumi.String("syncgroupcrud-8475"),
 * 			SyncDirection:                     pulumi.String("Bidirectional"),
 * 			SyncGroupName:                     pulumi.String("syncgroupcrud-3187"),
 * 			SyncMemberAzureDatabaseResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
 * 			SyncMemberName:                    pulumi.String("syncmembercrud-4879"),
 * 			UsePrivateLinkConnection:          pulumi.Bool(true),
 * 			UserName:                          pulumi.String("myUser"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncMember;
 * import com.pulumi.azurenative.sql.SyncMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncMember = new SyncMember("syncMember", SyncMemberArgs.builder()
 *             .databaseName("syncgroupcrud-7421")
 *             .databaseType("AzureSqlDatabase")
 *             .resourceGroupName("syncgroupcrud-65440")
 *             .serverName("syncgroupcrud-8475")
 *             .syncDirection("Bidirectional")
 *             .syncGroupName("syncgroupcrud-3187")
 *             .syncMemberAzureDatabaseResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328")
 *             .syncMemberName("syncmembercrud-4879")
 *             .usePrivateLinkConnection(true)
 *             .userName("myUser")
 *             .build());
 *     }
 * }
 * ```
 * ### Update a sync member
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var syncMember = new AzureNative.Sql.SyncMember("syncMember", new()
 *     {
 *         DatabaseName = "syncgroupcrud-7421",
 *         DatabaseType = "AzureSqlDatabase",
 *         ResourceGroupName = "syncgroupcrud-65440",
 *         ServerName = "syncgroupcrud-8475",
 *         SyncDirection = "Bidirectional",
 *         SyncGroupName = "syncgroupcrud-3187",
 *         SyncMemberAzureDatabaseResourceId = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328",
 *         SyncMemberName = "syncmembercrud-4879",
 *         UsePrivateLinkConnection = true,
 *         UserName = "myUser",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/sql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := sql.NewSyncMember(ctx, "syncMember", &sql.SyncMemberArgs{
 * 			DatabaseName:                      pulumi.String("syncgroupcrud-7421"),
 * 			DatabaseType:                      pulumi.String("AzureSqlDatabase"),
 * 			ResourceGroupName:                 pulumi.String("syncgroupcrud-65440"),
 * 			ServerName:                        pulumi.String("syncgroupcrud-8475"),
 * 			SyncDirection:                     pulumi.String("Bidirectional"),
 * 			SyncGroupName:                     pulumi.String("syncgroupcrud-3187"),
 * 			SyncMemberAzureDatabaseResourceId: pulumi.String("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328"),
 * 			SyncMemberName:                    pulumi.String("syncmembercrud-4879"),
 * 			UsePrivateLinkConnection:          pulumi.Bool(true),
 * 			UserName:                          pulumi.String("myUser"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.sql.SyncMember;
 * import com.pulumi.azurenative.sql.SyncMemberArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var syncMember = new SyncMember("syncMember", SyncMemberArgs.builder()
 *             .databaseName("syncgroupcrud-7421")
 *             .databaseType("AzureSqlDatabase")
 *             .resourceGroupName("syncgroupcrud-65440")
 *             .serverName("syncgroupcrud-8475")
 *             .syncDirection("Bidirectional")
 *             .syncGroupName("syncgroupcrud-3187")
 *             .syncMemberAzureDatabaseResourceId("/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/syncgroupcrud-65440/providers/Microsoft.Sql/servers/syncgroupcrud-8475/databases/syncgroupcrud-4328")
 *             .syncMemberName("syncmembercrud-4879")
 *             .usePrivateLinkConnection(true)
 *             .userName("myUser")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:sql:SyncMember syncmembercrud-4879 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/syncGroups/{syncGroupName}/syncMembers/{syncMemberName}
 * ```
 */
public class SyncMember internal constructor(
    override val javaResource: com.pulumi.azurenative.sql.SyncMember,
) : KotlinCustomResource(javaResource, SyncMemberMapper) {
    /**
     * Database name of the member database in the sync member.
     */
    public val databaseName: Output<String>?
        get() = javaResource.databaseName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Database type of the sync member.
     */
    public val databaseType: Output<String>?
        get() = javaResource.databaseType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Private endpoint name of the sync member if use private link connection is enabled, for sync members in Azure.
     */
    public val privateEndpointName: Output<String>
        get() = javaResource.privateEndpointName().applyValue({ args0 -> args0 })

    /**
     * Server name of the member database in the sync member
     */
    public val serverName: Output<String>?
        get() = javaResource.serverName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * SQL Server database id of the sync member.
     */
    public val sqlServerDatabaseId: Output<String>?
        get() = javaResource.sqlServerDatabaseId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM resource id of the sync agent in the sync member.
     */
    public val syncAgentId: Output<String>?
        get() = javaResource.syncAgentId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Sync direction of the sync member.
     */
    public val syncDirection: Output<String>?
        get() = javaResource.syncDirection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARM resource id of the sync member logical database, for sync members in Azure.
     */
    public val syncMemberAzureDatabaseResourceId: Output<String>?
        get() = javaResource.syncMemberAzureDatabaseResourceId().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * Sync state of the sync member.
     */
    public val syncState: Output<String>
        get() = javaResource.syncState().applyValue({ args0 -> args0 })

    /**
     * Resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Whether to use private link connection.
     */
    public val usePrivateLinkConnection: Output<Boolean>?
        get() = javaResource.usePrivateLinkConnection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * User name of the member database in the sync member.
     */
    public val userName: Output<String>?
        get() = javaResource.userName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SyncMemberMapper : ResourceMapper<SyncMember> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.sql.SyncMember::class == javaResource::class

    override fun map(javaResource: Resource): SyncMember = SyncMember(
        javaResource as
            com.pulumi.azurenative.sql.SyncMember,
    )
}

/**
 * @see [SyncMember].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SyncMember].
 */
public suspend fun syncMember(name: String, block: suspend SyncMemberResourceBuilder.() -> Unit):
    SyncMember {
    val builder = SyncMemberResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SyncMember].
 * @param name The _unique_ name of the resulting resource.
 */
public fun syncMember(name: String): SyncMember {
    val builder = SyncMemberResourceBuilder()
    builder.name(name)
    return builder.build()
}
