@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the mode of database creation.
 * Default: regular database creation.
 * Copy: creates a database as a copy of an existing database. sourceDatabaseId must be specified as the resource ID of the source database.
 * Secondary: creates a database as a secondary replica of an existing database. sourceDatabaseId must be specified as the resource ID of the existing primary database.
 * PointInTimeRestore: Creates a database by restoring a point in time backup of an existing database. sourceDatabaseId must be specified as the resource ID of the existing database, and restorePointInTime must be specified.
 * Recovery: Creates a database by restoring a geo-replicated backup. sourceDatabaseId must be specified as the recoverable database resource ID to restore.
 * Restore: Creates a database by restoring a backup of a deleted database. sourceDatabaseId must be specified. If sourceDatabaseId is the database's original resource ID, then sourceDatabaseDeletionDate must be specified. Otherwise sourceDatabaseId must be the restorable dropped database resource ID and sourceDatabaseDeletionDate is ignored. restorePointInTime may also be specified to restore from an earlier point in time.
 * RestoreLongTermRetentionBackup: Creates a database by restoring from a long term retention vault. recoveryServicesRecoveryPointResourceId must be specified as the recovery point resource ID.
 * Copy, Secondary, and RestoreLongTermRetentionBackup are not supported for DataWarehouse edition.
 */
public enum class CreateMode(
    public val javaValue: com.pulumi.azurenative.sql.enums.CreateMode,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.CreateMode> {
    Default(com.pulumi.azurenative.sql.enums.CreateMode.Default),
    Copy(com.pulumi.azurenative.sql.enums.CreateMode.Copy),
    Secondary(com.pulumi.azurenative.sql.enums.CreateMode.Secondary),
    PointInTimeRestore(com.pulumi.azurenative.sql.enums.CreateMode.PointInTimeRestore),
    Restore(com.pulumi.azurenative.sql.enums.CreateMode.Restore),
    Recovery(com.pulumi.azurenative.sql.enums.CreateMode.Recovery),
    RestoreExternalBackup(com.pulumi.azurenative.sql.enums.CreateMode.RestoreExternalBackup),
    RestoreExternalBackupSecondary(com.pulumi.azurenative.sql.enums.CreateMode.RestoreExternalBackupSecondary),
    RestoreLongTermRetentionBackup(com.pulumi.azurenative.sql.enums.CreateMode.RestoreLongTermRetentionBackup),
    OnlineSecondary(com.pulumi.azurenative.sql.enums.CreateMode.OnlineSecondary),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.CreateMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.CreateMode): CreateMode =
            CreateMode.values().first { it.javaValue == javaType }
    }
}
