@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Sync direction of the sync member.
 */
public enum class SyncDirection(
    public val javaValue: com.pulumi.azurenative.sql.enums.SyncDirection,
) : ConvertibleToJava<com.pulumi.azurenative.sql.enums.SyncDirection> {
    Bidirectional(com.pulumi.azurenative.sql.enums.SyncDirection.Bidirectional),
    OneWayMemberToHub(com.pulumi.azurenative.sql.enums.SyncDirection.OneWayMemberToHub),
    OneWayHubToMember(com.pulumi.azurenative.sql.enums.SyncDirection.OneWayHubToMember),
    ;

    override fun toJava(): com.pulumi.azurenative.sql.enums.SyncDirection = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.enums.SyncDirection): SyncDirection =
            SyncDirection.values().first { it.javaValue == javaType }
    }
}
