@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property baselineName The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
 * @property databaseName The name of the database for which the vulnerability assessment rule baseline is defined.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property ruleId The vulnerability assessment rule ID.
 * @property serverName The name of the server.
 * @property vulnerabilityAssessmentName The name of the vulnerability assessment.
 */
public data class GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs(
    public val baselineName: String,
    public val databaseName: String,
    public val resourceGroupName: String,
    public val ruleId: String,
    public val serverName: String,
    public val vulnerabilityAssessmentName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.sql.inputs.GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs =
        com.pulumi.azurenative.sql.inputs.GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs.builder()
            .baselineName(baselineName.let({ args0 -> args0 }))
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleId(ruleId.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .vulnerabilityAssessmentName(vulnerabilityAssessmentName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs].
 */
@PulumiTagMarker
public class GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgsBuilder internal constructor() {
    private var baselineName: String? = null

    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var ruleId: String? = null

    private var serverName: String? = null

    private var vulnerabilityAssessmentName: String? = null

    /**
     * @param value The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule).
     */
    @JvmName("mkcicfpfhggylutt")
    public suspend fun baselineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.baselineName = mapped
    }

    /**
     * @param value The name of the database for which the vulnerability assessment rule baseline is defined.
     */
    @JvmName("smqdfwjucrxmmuax")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("jqutelulloxbfvsa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The vulnerability assessment rule ID.
     */
    @JvmName("hdgjdwcjjfqvyqjc")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleId = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ecibipkujpfiacuu")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the vulnerability assessment.
     */
    @JvmName("gpwkjosuptimugri")
    public suspend fun vulnerabilityAssessmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vulnerabilityAssessmentName = mapped
    }

    internal fun build(): GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs =
        GetDatabaseVulnerabilityAssessmentRuleBaselinePlainArgs(
            baselineName = baselineName ?: throw PulumiNullFieldException("baselineName"),
            databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
            serverName = serverName ?: throw PulumiNullFieldException("serverName"),
            vulnerabilityAssessmentName = vulnerabilityAssessmentName ?: throw
                PulumiNullFieldException("vulnerabilityAssessmentName"),
        )
}
