@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetJobStepPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property jobAgentName The name of the job agent.
 * @property jobName The name of the job.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property stepName The name of the job step.
 */
public data class GetJobStepPlainArgs(
    public val jobAgentName: String,
    public val jobName: String,
    public val resourceGroupName: String,
    public val serverName: String,
    public val stepName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetJobStepPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetJobStepPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetJobStepPlainArgs.builder()
            .jobAgentName(jobAgentName.let({ args0 -> args0 }))
            .jobName(jobName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .stepName(stepName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetJobStepPlainArgs].
 */
@PulumiTagMarker
public class GetJobStepPlainArgsBuilder internal constructor() {
    private var jobAgentName: String? = null

    private var jobName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var stepName: String? = null

    /**
     * @param value The name of the job agent.
     */
    @JvmName("aagswivuqnnadfwm")
    public suspend fun jobAgentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobAgentName = mapped
    }

    /**
     * @param value The name of the job.
     */
    @JvmName("xjjuihyyfmoppkuw")
    public suspend fun jobName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.jobName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dseloarvefnogxmm")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("expkhfoxeonwjmfy")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the job step.
     */
    @JvmName("fhayhfppmpshqhyn")
    public suspend fun stepName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.stepName = mapped
    }

    internal fun build(): GetJobStepPlainArgs = GetJobStepPlainArgs(
        jobAgentName = jobAgentName ?: throw PulumiNullFieldException("jobAgentName"),
        jobName = jobName ?: throw PulumiNullFieldException("jobName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        stepName = stepName ?: throw PulumiNullFieldException("stepName"),
    )
}
