@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetManagedInstanceKeyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyName The name of the managed instance key to be retrieved.
 * @property managedInstanceName The name of the managed instance.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 */
public data class GetManagedInstanceKeyPlainArgs(
    public val keyName: String,
    public val managedInstanceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetManagedInstanceKeyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetManagedInstanceKeyPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetManagedInstanceKeyPlainArgs.builder()
            .keyName(keyName.let({ args0 -> args0 }))
            .managedInstanceName(managedInstanceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetManagedInstanceKeyPlainArgs].
 */
@PulumiTagMarker
public class GetManagedInstanceKeyPlainArgsBuilder internal constructor() {
    private var keyName: String? = null

    private var managedInstanceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the managed instance key to be retrieved.
     */
    @JvmName("uadvdkunehrfmafu")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyName = mapped
    }

    /**
     * @param value The name of the managed instance.
     */
    @JvmName("kafnndfvabbqhebk")
    public suspend fun managedInstanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.managedInstanceName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dgemfwqsicfkchmh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetManagedInstanceKeyPlainArgs = GetManagedInstanceKeyPlainArgs(
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        managedInstanceName = managedInstanceName ?: throw PulumiNullFieldException("managedInstanceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
