@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetReplicationLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database.
 * @property linkId The name of the replication link.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetReplicationLinkPlainArgs(
    public val databaseName: String,
    public val linkId: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetReplicationLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetReplicationLinkPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetReplicationLinkPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .linkId(linkId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationLinkPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationLinkPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var linkId: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("awbxpxnjawqgrnvo")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the replication link.
     */
    @JvmName("ivfvlcfkfkjcsvwb")
    public suspend fun linkId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.linkId = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("ijgjhpjlibdlouij")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("dkcgcyfrodammaxw")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetReplicationLinkPlainArgs = GetReplicationLinkPlainArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        linkId = linkId ?: throw PulumiNullFieldException("linkId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
