@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetServerBlobAuditingPolicyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property blobAuditingPolicyName The name of the blob auditing policy.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetServerBlobAuditingPolicyPlainArgs(
    public val blobAuditingPolicyName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetServerBlobAuditingPolicyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetServerBlobAuditingPolicyPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetServerBlobAuditingPolicyPlainArgs.builder()
            .blobAuditingPolicyName(blobAuditingPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerBlobAuditingPolicyPlainArgs].
 */
@PulumiTagMarker
public class GetServerBlobAuditingPolicyPlainArgsBuilder internal constructor() {
    private var blobAuditingPolicyName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the blob auditing policy.
     */
    @JvmName("bfsjakyvaqmtpsfb")
    public suspend fun blobAuditingPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.blobAuditingPolicyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("xfpyptoiskghramy")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("cxvpsqfvyggujjxs")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetServerBlobAuditingPolicyPlainArgs = GetServerBlobAuditingPolicyPlainArgs(
        blobAuditingPolicyName = blobAuditingPolicyName ?: throw
            PulumiNullFieldException("blobAuditingPolicyName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
