@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetServerCommunicationLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property communicationLinkName The name of the server communication link.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 */
public data class GetServerCommunicationLinkPlainArgs(
    public val communicationLinkName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetServerCommunicationLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetServerCommunicationLinkPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetServerCommunicationLinkPlainArgs.builder()
            .communicationLinkName(communicationLinkName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerCommunicationLinkPlainArgs].
 */
@PulumiTagMarker
public class GetServerCommunicationLinkPlainArgsBuilder internal constructor() {
    private var communicationLinkName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the server communication link.
     */
    @JvmName("brylnudiggmyoxiq")
    public suspend fun communicationLinkName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.communicationLinkName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("dbjhtljtyauytfcq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("ugaffeomwhfoidyw")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetServerCommunicationLinkPlainArgs = GetServerCommunicationLinkPlainArgs(
        communicationLinkName = communicationLinkName ?: throw
            PulumiNullFieldException("communicationLinkName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
