@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetServerDnsAliasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsAliasName The name of the server dns alias.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server that the alias is pointing to.
 */
public data class GetServerDnsAliasPlainArgs(
    public val dnsAliasName: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetServerDnsAliasPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetServerDnsAliasPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetServerDnsAliasPlainArgs.builder()
            .dnsAliasName(dnsAliasName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerDnsAliasPlainArgs].
 */
@PulumiTagMarker
public class GetServerDnsAliasPlainArgsBuilder internal constructor() {
    private var dnsAliasName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the server dns alias.
     */
    @JvmName("ponbabfpmalxnrqb")
    public suspend fun dnsAliasName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsAliasName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("fectkiyitmnjbydv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server that the alias is pointing to.
     */
    @JvmName("riysymocxrxdopnx")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetServerDnsAliasPlainArgs = GetServerDnsAliasPlainArgs(
        dnsAliasName = dnsAliasName ?: throw PulumiNullFieldException("dnsAliasName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
