@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.GetWorkloadClassifierPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property databaseName The name of the database.
 * @property resourceGroupName The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
 * @property serverName The name of the server.
 * @property workloadClassifierName The name of the workload classifier.
 * @property workloadGroupName The name of the workload group from which to receive the classifier from.
 */
public data class GetWorkloadClassifierPlainArgs(
    public val databaseName: String,
    public val resourceGroupName: String,
    public val serverName: String,
    public val workloadClassifierName: String,
    public val workloadGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.GetWorkloadClassifierPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.GetWorkloadClassifierPlainArgs =
        com.pulumi.azurenative.sql.inputs.GetWorkloadClassifierPlainArgs.builder()
            .databaseName(databaseName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 }))
            .workloadClassifierName(workloadClassifierName.let({ args0 -> args0 }))
            .workloadGroupName(workloadGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWorkloadClassifierPlainArgs].
 */
@PulumiTagMarker
public class GetWorkloadClassifierPlainArgsBuilder internal constructor() {
    private var databaseName: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    private var workloadClassifierName: String? = null

    private var workloadGroupName: String? = null

    /**
     * @param value The name of the database.
     */
    @JvmName("egtfafcqqmwmsvmk")
    public suspend fun databaseName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.databaseName = mapped
    }

    /**
     * @param value The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal.
     */
    @JvmName("quetcsyontixtyhl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("rwoaikkbibalqgpb")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    /**
     * @param value The name of the workload classifier.
     */
    @JvmName("rqksbgqsgngsogdd")
    public suspend fun workloadClassifierName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workloadClassifierName = mapped
    }

    /**
     * @param value The name of the workload group from which to receive the classifier from.
     */
    @JvmName("hkmriaxpohcbcyra")
    public suspend fun workloadGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.workloadGroupName = mapped
    }

    internal fun build(): GetWorkloadClassifierPlainArgs = GetWorkloadClassifierPlainArgs(
        databaseName = databaseName ?: throw PulumiNullFieldException("databaseName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
        workloadClassifierName = workloadClassifierName ?: throw
            PulumiNullFieldException("workloadClassifierName"),
        workloadGroupName = workloadGroupName ?: throw PulumiNullFieldException("workloadGroupName"),
    )
}
