@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.JobStepActionArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.JobStepActionSource
import com.pulumi.azurenative.sql.kotlin.enums.JobStepActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The action to be executed by a job step.
 * @property source The source of the action to execute.
 * @property type Type of action being executed by the job step.
 * @property value The action value, for example the text of the T-SQL script to execute.
 */
public data class JobStepActionArgs(
    public val source: Output<Either<String, JobStepActionSource>>? = null,
    public val type: Output<Either<String, JobStepActionType>>? = null,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.JobStepActionArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.JobStepActionArgs =
        com.pulumi.azurenative.sql.inputs.JobStepActionArgs.builder()
            .source(
                source?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JobStepActionArgs].
 */
@PulumiTagMarker
public class JobStepActionArgsBuilder internal constructor() {
    private var source: Output<Either<String, JobStepActionSource>>? = null

    private var type: Output<Either<String, JobStepActionType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The source of the action to execute.
     */
    @JvmName("mjnaivdnvabxslxa")
    public suspend fun source(`value`: Output<Either<String, JobStepActionSource>>) {
        this.source = value
    }

    /**
     * @param value Type of action being executed by the job step.
     */
    @JvmName("ruhuxrtrgpjeiolx")
    public suspend fun type(`value`: Output<Either<String, JobStepActionType>>) {
        this.type = value
    }

    /**
     * @param value The action value, for example the text of the T-SQL script to execute.
     */
    @JvmName("pwnpxgqcwhvhiqlq")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The source of the action to execute.
     */
    @JvmName("tmtrqcqbfuldarij")
    public suspend fun source(`value`: Either<String, JobStepActionSource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The source of the action to execute.
     */
    @JvmName("mjglelbdqcipndxn")
    public fun source(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JobStepActionSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The source of the action to execute.
     */
    @JvmName("okewoagbmbgkuftw")
    public fun source(`value`: JobStepActionSource) {
        val toBeMapped = Either.ofRight<String, JobStepActionSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value Type of action being executed by the job step.
     */
    @JvmName("kgvhtrrybehvoiyp")
    public suspend fun type(`value`: Either<String, JobStepActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of action being executed by the job step.
     */
    @JvmName("wsrqadvuvblrbfxu")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JobStepActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of action being executed by the job step.
     */
    @JvmName("kgtueepmlslaxhps")
    public fun type(`value`: JobStepActionType) {
        val toBeMapped = Either.ofRight<String, JobStepActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The action value, for example the text of the T-SQL script to execute.
     */
    @JvmName("puuumpboubsbucik")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): JobStepActionArgs = JobStepActionArgs(
        source = source,
        type = type,
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
