@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.ScheduleItemArgs.builder
import com.pulumi.azurenative.sql.kotlin.enums.DayOfWeek
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Schedule info describing when the server should be started or stopped.
 * @property startDay Start day.
 * @property startTime Start time.
 * @property stopDay Stop day.
 * @property stopTime Stop time.
 */
public data class ScheduleItemArgs(
    public val startDay: Output<Either<String, DayOfWeek>>,
    public val startTime: Output<String>,
    public val stopDay: Output<Either<String, DayOfWeek>>,
    public val stopTime: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.ScheduleItemArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.ScheduleItemArgs =
        com.pulumi.azurenative.sql.inputs.ScheduleItemArgs.builder()
            .startDay(
                startDay.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .startTime(startTime.applyValue({ args0 -> args0 }))
            .stopDay(
                stopDay.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .stopTime(stopTime.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ScheduleItemArgs].
 */
@PulumiTagMarker
public class ScheduleItemArgsBuilder internal constructor() {
    private var startDay: Output<Either<String, DayOfWeek>>? = null

    private var startTime: Output<String>? = null

    private var stopDay: Output<Either<String, DayOfWeek>>? = null

    private var stopTime: Output<String>? = null

    /**
     * @param value Start day.
     */
    @JvmName("qulirtblxcnbebwd")
    public suspend fun startDay(`value`: Output<Either<String, DayOfWeek>>) {
        this.startDay = value
    }

    /**
     * @param value Start time.
     */
    @JvmName("uflqoujrxedvtpnn")
    public suspend fun startTime(`value`: Output<String>) {
        this.startTime = value
    }

    /**
     * @param value Stop day.
     */
    @JvmName("tjqwbuukfitxpebu")
    public suspend fun stopDay(`value`: Output<Either<String, DayOfWeek>>) {
        this.stopDay = value
    }

    /**
     * @param value Stop time.
     */
    @JvmName("ectrjuugdiixmyus")
    public suspend fun stopTime(`value`: Output<String>) {
        this.stopTime = value
    }

    /**
     * @param value Start day.
     */
    @JvmName("omknjdejhxesvmvg")
    public suspend fun startDay(`value`: Either<String, DayOfWeek>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startDay = mapped
    }

    /**
     * @param value Start day.
     */
    @JvmName("fsaljmeqbqkcibpk")
    public fun startDay(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DayOfWeek>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startDay = mapped
    }

    /**
     * @param value Start day.
     */
    @JvmName("wlvoljrfbpvurhxc")
    public fun startDay(`value`: DayOfWeek) {
        val toBeMapped = Either.ofRight<String, DayOfWeek>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startDay = mapped
    }

    /**
     * @param value Start time.
     */
    @JvmName("xqwxdgxptwrtbgcd")
    public suspend fun startTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startTime = mapped
    }

    /**
     * @param value Stop day.
     */
    @JvmName("jwqrkihyhxmqpvuj")
    public suspend fun stopDay(`value`: Either<String, DayOfWeek>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopDay = mapped
    }

    /**
     * @param value Stop day.
     */
    @JvmName("hjyqknjkbvljbjrf")
    public fun stopDay(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DayOfWeek>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopDay = mapped
    }

    /**
     * @param value Stop day.
     */
    @JvmName("fgcynotntxqgnuwp")
    public fun stopDay(`value`: DayOfWeek) {
        val toBeMapped = Either.ofRight<String, DayOfWeek>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopDay = mapped
    }

    /**
     * @param value Stop time.
     */
    @JvmName("wvxkwgsqfrjniahr")
    public suspend fun stopTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stopTime = mapped
    }

    internal fun build(): ScheduleItemArgs = ScheduleItemArgs(
        startDay = startDay ?: throw PulumiNullFieldException("startDay"),
        startTime = startTime ?: throw PulumiNullFieldException("startTime"),
        stopDay = stopDay ?: throw PulumiNullFieldException("stopDay"),
        stopTime = stopTime ?: throw PulumiNullFieldException("stopTime"),
    )
}
