@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.inputs

import com.pulumi.azurenative.sql.inputs.SyncGroupSchemaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Properties of sync group schema.
 * @property masterSyncMemberName Name of master sync member where the schema is from.
 * @property tables List of tables in sync group schema.
 */
public data class SyncGroupSchemaArgs(
    public val masterSyncMemberName: Output<String>? = null,
    public val tables: Output<List<SyncGroupSchemaTableArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.sql.inputs.SyncGroupSchemaArgs> {
    override fun toJava(): com.pulumi.azurenative.sql.inputs.SyncGroupSchemaArgs =
        com.pulumi.azurenative.sql.inputs.SyncGroupSchemaArgs.builder()
            .masterSyncMemberName(masterSyncMemberName?.applyValue({ args0 -> args0 }))
            .tables(
                tables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SyncGroupSchemaArgs].
 */
@PulumiTagMarker
public class SyncGroupSchemaArgsBuilder internal constructor() {
    private var masterSyncMemberName: Output<String>? = null

    private var tables: Output<List<SyncGroupSchemaTableArgs>>? = null

    /**
     * @param value Name of master sync member where the schema is from.
     */
    @JvmName("dcvxfjwycfjbmbtm")
    public suspend fun masterSyncMemberName(`value`: Output<String>) {
        this.masterSyncMemberName = value
    }

    /**
     * @param value List of tables in sync group schema.
     */
    @JvmName("dtvcboclctjymlky")
    public suspend fun tables(`value`: Output<List<SyncGroupSchemaTableArgs>>) {
        this.tables = value
    }

    @JvmName("vuugshwnrfskymmg")
    public suspend fun tables(vararg values: Output<SyncGroupSchemaTableArgs>) {
        this.tables = Output.all(values.asList())
    }

    /**
     * @param values List of tables in sync group schema.
     */
    @JvmName("gmstpjgakjypiyxa")
    public suspend fun tables(values: List<Output<SyncGroupSchemaTableArgs>>) {
        this.tables = Output.all(values)
    }

    /**
     * @param value Name of master sync member where the schema is from.
     */
    @JvmName("lbigbkfvwtjhampy")
    public suspend fun masterSyncMemberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.masterSyncMemberName = mapped
    }

    /**
     * @param value List of tables in sync group schema.
     */
    @JvmName("rpxwqrbeidlfygxg")
    public suspend fun tables(`value`: List<SyncGroupSchemaTableArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tables = mapped
    }

    /**
     * @param argument List of tables in sync group schema.
     */
    @JvmName("sshsnwlifmscxxhe")
    public suspend fun tables(argument: List<suspend SyncGroupSchemaTableArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            SyncGroupSchemaTableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tables = mapped
    }

    /**
     * @param argument List of tables in sync group schema.
     */
    @JvmName("dvvrrkcwpwfninxs")
    public suspend fun tables(vararg argument: suspend SyncGroupSchemaTableArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            SyncGroupSchemaTableArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tables = mapped
    }

    /**
     * @param argument List of tables in sync group schema.
     */
    @JvmName("htyrkaokpotvcnet")
    public suspend fun tables(argument: suspend SyncGroupSchemaTableArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(SyncGroupSchemaTableArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tables = mapped
    }

    /**
     * @param values List of tables in sync group schema.
     */
    @JvmName("cjsucqpdvuunjvbh")
    public suspend fun tables(vararg values: SyncGroupSchemaTableArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tables = mapped
    }

    internal fun build(): SyncGroupSchemaArgs = SyncGroupSchemaArgs(
        masterSyncMemberName = masterSyncMemberName,
        tables = tables,
    )
}
