@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The server encryption protector.
 * @property autoRotationEnabled Key auto rotation opt-in flag. Either true or false.
 * @property id Resource ID.
 * @property kind Kind of encryption protector. This is metadata used for the Azure portal experience.
 * @property location Resource location.
 * @property name Resource name.
 * @property serverKeyName The name of the server key.
 * @property serverKeyType The encryption protector type like 'ServiceManaged', 'AzureKeyVault'.
 * @property subregion Subregion of the encryption protector.
 * @property thumbprint Thumbprint of the server key.
 * @property type Resource type.
 * @property uri The URI of the server key.
 */
public data class GetEncryptionProtectorResult(
    public val autoRotationEnabled: Boolean? = null,
    public val id: String,
    public val kind: String,
    public val location: String,
    public val name: String,
    public val serverKeyName: String? = null,
    public val serverKeyType: String,
    public val subregion: String,
    public val thumbprint: String,
    public val type: String,
    public val uri: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetEncryptionProtectorResult):
            GetEncryptionProtectorResult = GetEncryptionProtectorResult(
            autoRotationEnabled = javaType.autoRotationEnabled().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            kind = javaType.kind(),
            location = javaType.location(),
            name = javaType.name(),
            serverKeyName = javaType.serverKeyName().map({ args0 -> args0 }).orElse(null),
            serverKeyType = javaType.serverKeyType(),
            subregion = javaType.subregion(),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
            uri = javaType.uri(),
        )
    }
}
