@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A group of job targets.
 * @property id Resource ID.
 * @property members Members of the target group.
 * @property name Resource name.
 * @property type Resource type.
 */
public data class GetJobTargetGroupResult(
    public val id: String,
    public val members: List<JobTargetResponse>,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetJobTargetGroupResult):
            GetJobTargetGroupResult = GetJobTargetGroupResult(
            id = javaType.id(),
            members = javaType.members().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.JobTargetResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
