@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A managed instance vulnerability assessment.
 * @property id Resource ID.
 * @property name Resource name.
 * @property recurringScans The recurring scans settings
 * @property type Resource type.
 */
public data class GetManagedInstanceVulnerabilityAssessmentResult(
    public val id: String,
    public val name: String,
    public val recurringScans: VulnerabilityAssessmentRecurringScansPropertiesResponse? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetManagedInstanceVulnerabilityAssessmentResult):
            GetManagedInstanceVulnerabilityAssessmentResult =
            GetManagedInstanceVulnerabilityAssessmentResult(
                id = javaType.id(),
                name = javaType.name(),
                recurringScans = javaType.recurringScans().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sql.kotlin.outputs.VulnerabilityAssessmentRecurringScansPropertiesResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                type = javaType.type(),
            )
    }
}
