@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Database, Server or Elastic Pool Advisor.
 * @property advisorStatus Gets the status of availability of this advisor to customers. Possible values are 'GA', 'PublicPreview', 'LimitedPublicPreview' and 'PrivatePreview'.
 * @property autoExecuteStatus Gets the auto-execute status (whether to let the system execute the recommendations) of this advisor. Possible values are 'Enabled' and 'Disabled'
 * @property autoExecuteStatusInheritedFrom Gets the resource from which current value of auto-execute status is inherited. Auto-execute status can be set on (and inherited from) different levels in the resource hierarchy. Possible values are 'Subscription', 'Server', 'ElasticPool', 'Database' and 'Default' (when status is not explicitly set on any level).
 * @property id Resource ID.
 * @property kind Resource kind.
 * @property lastChecked Gets the time when the current resource was analyzed for recommendations by this advisor.
 * @property location Resource location.
 * @property name Resource name.
 * @property recommendationsStatus Gets that status of recommendations for this advisor and reason for not having any recommendations. Possible values include, but are not limited to, 'Ok' (Recommendations available),LowActivity (not enough workload to analyze), 'DbSeemsTuned' (Database is doing well), etc.
 * @property recommendedActions Gets the recommended actions for this advisor.
 * @property type Resource type.
 */
public data class GetServerAdvisorResult(
    public val advisorStatus: String,
    public val autoExecuteStatus: String,
    public val autoExecuteStatusInheritedFrom: String,
    public val id: String,
    public val kind: String,
    public val lastChecked: String,
    public val location: String,
    public val name: String,
    public val recommendationsStatus: String,
    public val recommendedActions: List<RecommendedActionResponse>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetServerAdvisorResult):
            GetServerAdvisorResult = GetServerAdvisorResult(
            advisorStatus = javaType.advisorStatus(),
            autoExecuteStatus = javaType.autoExecuteStatus(),
            autoExecuteStatusInheritedFrom = javaType.autoExecuteStatusInheritedFrom(),
            id = javaType.id(),
            kind = javaType.kind(),
            lastChecked = javaType.lastChecked(),
            location = javaType.location(),
            name = javaType.name(),
            recommendationsStatus = javaType.recommendationsStatus(),
            recommendedActions = javaType.recommendedActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.RecommendedActionResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
