@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * An Azure SQL Database server.
 * @property administratorLogin Administrator username for the server. Once created it cannot be changed.
 * @property administrators The Azure Active Directory administrator of the server.
 * @property federatedClientId The Client id used for cross tenant CMK scenario
 * @property fullyQualifiedDomainName The fully qualified domain name of the server.
 * @property id Resource ID.
 * @property identity The Azure Active Directory identity of the server.
 * @property keyId A CMK URI of the key to use for encryption.
 * @property kind Kind of sql server. This is metadata used for the Azure portal experience.
 * @property location Resource location.
 * @property minimalTlsVersion Minimal TLS version. Allowed values: '1.0', '1.1', '1.2'
 * @property name Resource name.
 * @property primaryUserAssignedIdentityId The resource id of a user assigned identity to be used by default.
 * @property privateEndpointConnections List of private endpoint connections on a server
 * @property publicNetworkAccess Whether or not public endpoint access is allowed for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 * @property restrictOutboundNetworkAccess Whether or not to restrict outbound network access for this server.  Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 * @property state The state of the server.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property version The version of the server.
 * @property workspaceFeature Whether or not existing server has a workspace created and if it allows connection from workspace
 */
public data class GetServerResult(
    public val administratorLogin: String? = null,
    public val administrators: ServerExternalAdministratorResponse? = null,
    public val federatedClientId: String? = null,
    public val fullyQualifiedDomainName: String,
    public val id: String,
    public val identity: ResourceIdentityResponse? = null,
    public val keyId: String? = null,
    public val kind: String,
    public val location: String,
    public val minimalTlsVersion: String? = null,
    public val name: String,
    public val primaryUserAssignedIdentityId: String? = null,
    public val privateEndpointConnections: List<ServerPrivateEndpointConnectionResponse>,
    public val publicNetworkAccess: String? = null,
    public val restrictOutboundNetworkAccess: String? = null,
    public val state: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val version: String? = null,
    public val workspaceFeature: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetServerResult):
            GetServerResult = GetServerResult(
            administratorLogin = javaType.administratorLogin().map({ args0 -> args0 }).orElse(null),
            administrators = javaType.administrators().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ServerExternalAdministratorResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            federatedClientId = javaType.federatedClientId().map({ args0 -> args0 }).orElse(null),
            fullyQualifiedDomainName = javaType.fullyQualifiedDomainName(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ResourceIdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            keyId = javaType.keyId().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            location = javaType.location(),
            minimalTlsVersion = javaType.minimalTlsVersion().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            primaryUserAssignedIdentityId = javaType.primaryUserAssignedIdentityId().map({ args0 ->
                args0
            }).orElse(null),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.ServerPrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            restrictOutboundNetworkAccess = javaType.restrictOutboundNetworkAccess().map({ args0 ->
                args0
            }).orElse(null),
            state = javaType.state(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
            workspaceFeature = javaType.workspaceFeature(),
        )
    }
}
