@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Server trust certificate imported from box to enable connection between box and Sql Managed Instance.
 * @property certificateName The certificate name
 * @property id Resource ID.
 * @property name Resource name.
 * @property publicBlob The certificate public blob
 * @property thumbprint The certificate thumbprint
 * @property type Resource type.
 */
public data class GetServerTrustCertificateResult(
    public val certificateName: String,
    public val id: String,
    public val name: String,
    public val publicBlob: String? = null,
    public val thumbprint: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.GetServerTrustCertificateResult):
            GetServerTrustCertificateResult = GetServerTrustCertificateResult(
            certificateName = javaType.certificateName(),
            id = javaType.id(),
            name = javaType.name(),
            publicBlob = javaType.publicBlob().map({ args0 -> args0 }).orElse(null),
            thumbprint = javaType.thumbprint(),
            type = javaType.type(),
        )
    }
}
