@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The action to be executed by a job step.
 * @property source The source of the action to execute.
 * @property type Type of action being executed by the job step.
 * @property value The action value, for example the text of the T-SQL script to execute.
 */
public data class JobStepActionResponse(
    public val source: String? = null,
    public val type: String? = null,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.JobStepActionResponse):
            JobStepActionResponse = JobStepActionResponse(
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`(),
        )
    }
}
