@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of a private endpoint connection.
 * @property privateEndpoint Private endpoint which the connection belongs to.
 * @property privateLinkServiceConnectionState Connection State of the Private Endpoint Connection.
 * @property provisioningState State of the Private Endpoint Connection.
 */
public data class ManagedInstancePrivateEndpointConnectionPropertiesResponse(
    public val privateEndpoint: ManagedInstancePrivateEndpointPropertyResponse? = null,
    public val privateLinkServiceConnectionState:
    ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse? = null,
    public val provisioningState: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.ManagedInstancePrivateEndpointConnectionPropertiesResponse):
            ManagedInstancePrivateEndpointConnectionPropertiesResponse =
            ManagedInstancePrivateEndpointConnectionPropertiesResponse(
                privateEndpoint = javaType.privateEndpoint().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePrivateEndpointPropertyResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                privateLinkServiceConnectionState = javaType.privateLinkServiceConnectionState().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.sql.kotlin.outputs.ManagedInstancePrivateLinkServiceConnectionStatePropertyResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                provisioningState = javaType.provisioningState(),
            )
    }
}
