@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Database, Server or Elastic Pool Recommended Action.
 * @property details Gets additional details specific to this recommended action.
 * @property errorDetails Gets the error details if and why this recommended action is put to error state.
 * @property estimatedImpact Gets the estimated impact info for this recommended action e.g., Estimated CPU gain, Estimated Disk Space change
 * @property executeActionDuration Gets the time taken for applying this recommended action on user resource. e.g., time taken for index creation
 * @property executeActionInitiatedBy Gets if approval for applying this recommended action was given by user/system.
 * @property executeActionInitiatedTime Gets the time when this recommended action was approved for execution.
 * @property executeActionStartTime Gets the time when system started applying this recommended action on the user resource. e.g., index creation start time
 * @property id Resource ID.
 * @property implementationDetails Gets the implementation details of this recommended action for user to apply it manually.
 * @property isArchivedAction Gets if this recommended action was suggested some time ago but user chose to ignore this and system added a new recommended action again.
 * @property isExecutableAction Gets if this recommended action is actionable by user
 * @property isRevertableAction Gets if changes applied by this recommended action can be reverted by user
 * @property kind Resource kind.
 * @property lastRefresh Gets time when this recommended action was last refreshed.
 * @property linkedObjects Gets the linked objects, if any.
 * @property location Resource location.
 * @property name Resource name.
 * @property observedImpact Gets the observed/actual impact info for this recommended action e.g., Actual CPU gain, Actual Disk Space change
 * @property recommendationReason Gets the reason for recommending this action. e.g., DuplicateIndex
 * @property revertActionDuration Gets the time taken for reverting changes of this recommended action on user resource. e.g., time taken for dropping the created index.
 * @property revertActionInitiatedBy Gets if approval for reverting this recommended action was given by user/system.
 * @property revertActionInitiatedTime Gets the time when this recommended action was approved for revert.
 * @property revertActionStartTime Gets the time when system started reverting changes of this recommended action on user resource. e.g., time when index drop is executed.
 * @property score Gets the impact of this recommended action. Possible values are 1 - Low impact, 2 - Medium Impact and 3 - High Impact
 * @property state Gets the info of the current state the recommended action is in.
 * @property timeSeries Gets the time series info of metrics for this recommended action e.g., CPU consumption time series
 * @property type Resource type.
 * @property validSince Gets the time since when this recommended action is valid.
 */
public data class RecommendedActionResponse(
    public val details: Map<String, Any>,
    public val errorDetails: RecommendedActionErrorInfoResponse,
    public val estimatedImpact: List<RecommendedActionImpactRecordResponse>,
    public val executeActionDuration: String,
    public val executeActionInitiatedBy: String,
    public val executeActionInitiatedTime: String,
    public val executeActionStartTime: String,
    public val id: String,
    public val implementationDetails: RecommendedActionImplementationInfoResponse,
    public val isArchivedAction: Boolean,
    public val isExecutableAction: Boolean,
    public val isRevertableAction: Boolean,
    public val kind: String,
    public val lastRefresh: String,
    public val linkedObjects: List<String>,
    public val location: String,
    public val name: String,
    public val observedImpact: List<RecommendedActionImpactRecordResponse>,
    public val recommendationReason: String,
    public val revertActionDuration: String,
    public val revertActionInitiatedBy: String,
    public val revertActionInitiatedTime: String,
    public val revertActionStartTime: String,
    public val score: Int,
    public val state: RecommendedActionStateInfoResponse,
    public val timeSeries: List<RecommendedActionMetricInfoResponse>,
    public val type: String,
    public val validSince: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.RecommendedActionResponse):
            RecommendedActionResponse = RecommendedActionResponse(
            details = javaType.details().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            errorDetails = javaType.errorDetails().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.RecommendedActionErrorInfoResponse.Companion.toKotlin(args0)
            }),
            estimatedImpact = javaType.estimatedImpact().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.RecommendedActionImpactRecordResponse.Companion.toKotlin(args0)
                })
            }),
            executeActionDuration = javaType.executeActionDuration(),
            executeActionInitiatedBy = javaType.executeActionInitiatedBy(),
            executeActionInitiatedTime = javaType.executeActionInitiatedTime(),
            executeActionStartTime = javaType.executeActionStartTime(),
            id = javaType.id(),
            implementationDetails = javaType.implementationDetails().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.RecommendedActionImplementationInfoResponse.Companion.toKotlin(args0)
            }),
            isArchivedAction = javaType.isArchivedAction(),
            isExecutableAction = javaType.isExecutableAction(),
            isRevertableAction = javaType.isRevertableAction(),
            kind = javaType.kind(),
            lastRefresh = javaType.lastRefresh(),
            linkedObjects = javaType.linkedObjects().map({ args0 -> args0 }),
            location = javaType.location(),
            name = javaType.name(),
            observedImpact = javaType.observedImpact().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.RecommendedActionImpactRecordResponse.Companion.toKotlin(args0)
                })
            }),
            recommendationReason = javaType.recommendationReason(),
            revertActionDuration = javaType.revertActionDuration(),
            revertActionInitiatedBy = javaType.revertActionInitiatedBy(),
            revertActionInitiatedTime = javaType.revertActionInitiatedTime(),
            revertActionStartTime = javaType.revertActionStartTime(),
            score = javaType.score(),
            state = javaType.state().let({ args0 ->
                com.pulumi.azurenative.sql.kotlin.outputs.RecommendedActionStateInfoResponse.Companion.toKotlin(args0)
            }),
            timeSeries = javaType.timeSeries().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.RecommendedActionMetricInfoResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            validSince = javaType.validSince(),
        )
    }
}
