@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.sql.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Properties of sync group schema.
 * @property masterSyncMemberName Name of master sync member where the schema is from.
 * @property tables List of tables in sync group schema.
 */
public data class SyncGroupSchemaResponse(
    public val masterSyncMemberName: String? = null,
    public val tables: List<SyncGroupSchemaTableResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.sql.outputs.SyncGroupSchemaResponse):
            SyncGroupSchemaResponse = SyncGroupSchemaResponse(
            masterSyncMemberName = javaType.masterSyncMemberName().map({ args0 -> args0 }).orElse(null),
            tables = javaType.tables().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.sql.kotlin.outputs.SyncGroupSchemaTableResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
